package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListFeaturesResponse(
    features: Option[Iterable[zio.aws.evidently.model.FeatureSummary]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ListFeaturesResponse = {
    import ListFeaturesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ListFeaturesResponse
      .builder()
      .optionallyWith(
        features.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.features)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.ListFeaturesResponse.ReadOnly =
    zio.aws.evidently.model.ListFeaturesResponse.wrap(buildAwsValue())
}
object ListFeaturesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ListFeaturesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ListFeaturesResponse =
      zio.aws.evidently.model.ListFeaturesResponse(
        features.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def features: Option[List[zio.aws.evidently.model.FeatureSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getFeatures: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.FeatureSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("features", features)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ListFeaturesResponse
  ) extends zio.aws.evidently.model.ListFeaturesResponse.ReadOnly {
    override val features
        : Option[List[zio.aws.evidently.model.FeatureSummary.ReadOnly]] = scala
      .Option(impl.features())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.evidently.model.FeatureSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.evidently.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ListFeaturesResponse
  ): zio.aws.evidently.model.ListFeaturesResponse.ReadOnly = new Wrapper(impl)
}
