package zio.aws.evidently.model
import java.lang.Integer
import zio.aws.evidently.model.primitives.{
  ProjectRef,
  NextToken,
  MaxExperiments
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListExperimentsRequest(
    maxResults: Option[MaxExperiments] = None,
    nextToken: Option[NextToken] = None,
    project: ProjectRef
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ListExperimentsRequest = {
    import ListExperimentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ListExperimentsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxExperiments.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .project(ProjectRef.unwrap(project): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.ListExperimentsRequest.ReadOnly =
    zio.aws.evidently.model.ListExperimentsRequest.wrap(buildAwsValue())
}
object ListExperimentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ListExperimentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ListExperimentsRequest =
      zio.aws.evidently.model.ListExperimentsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        project
      )
    def maxResults: Option[MaxExperiments]
    def nextToken: Option[NextToken]
    def project: ProjectRef
    def getMaxResults: ZIO[Any, AwsError, MaxExperiments] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ListExperimentsRequest
  ) extends zio.aws.evidently.model.ListExperimentsRequest.ReadOnly {
    override val maxResults: Option[MaxExperiments] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.evidently.model.primitives.MaxExperiments(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.evidently.model.primitives.NextToken(value))
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ListExperimentsRequest
  ): zio.aws.evidently.model.ListExperimentsRequest.ReadOnly = new Wrapper(impl)
}
