package zio.aws.evidently.model
import scala.jdk.CollectionConverters._
sealed trait LaunchStopDesiredState {
  def unwrap
      : software.amazon.awssdk.services.evidently.model.LaunchStopDesiredState
}
object LaunchStopDesiredState {
  def wrap(
      value: software.amazon.awssdk.services.evidently.model.LaunchStopDesiredState
  ): zio.aws.evidently.model.LaunchStopDesiredState = value match {
    case software.amazon.awssdk.services.evidently.model.LaunchStopDesiredState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.evidently.model.LaunchStopDesiredState.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.evidently.model.LaunchStopDesiredState.CANCELLED =>
      val r = CANCELLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.evidently.model.LaunchStopDesiredState {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.LaunchStopDesiredState =
      software.amazon.awssdk.services.evidently.model.LaunchStopDesiredState.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPLETED extends zio.aws.evidently.model.LaunchStopDesiredState {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.LaunchStopDesiredState =
      software.amazon.awssdk.services.evidently.model.LaunchStopDesiredState.COMPLETED
  }
  case object CANCELLED extends zio.aws.evidently.model.LaunchStopDesiredState {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.LaunchStopDesiredState =
      software.amazon.awssdk.services.evidently.model.LaunchStopDesiredState.CANCELLED
  }
}
