package zio.aws.evidently.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetExperimentResponse(
    experiment: Option[zio.aws.evidently.model.Experiment] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.GetExperimentResponse = {
    import GetExperimentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.GetExperimentResponse
      .builder()
      .optionallyWith(experiment.map(value => value.buildAwsValue()))(
        _.experiment
      )
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.GetExperimentResponse.ReadOnly =
    zio.aws.evidently.model.GetExperimentResponse.wrap(buildAwsValue())
}
object GetExperimentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.GetExperimentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.GetExperimentResponse =
      zio.aws.evidently.model
        .GetExperimentResponse(experiment.map(value => value.asEditable))
    def experiment: Option[zio.aws.evidently.model.Experiment.ReadOnly]
    def getExperiment
        : ZIO[Any, AwsError, zio.aws.evidently.model.Experiment.ReadOnly] =
      AwsError.unwrapOptionField("experiment", experiment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.GetExperimentResponse
  ) extends zio.aws.evidently.model.GetExperimentResponse.ReadOnly {
    override val experiment
        : Option[zio.aws.evidently.model.Experiment.ReadOnly] = scala
      .Option(impl.experiment())
      .map(value => zio.aws.evidently.model.Experiment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.GetExperimentResponse
  ): zio.aws.evidently.model.GetExperimentResponse.ReadOnly = new Wrapper(impl)
}
