package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  VariationName,
  Timestamp,
  TagValue,
  ProjectRef,
  Arn,
  FeatureName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class FeatureSummary(
    arn: Arn,
    createdTime: Timestamp,
    defaultVariation: Option[VariationName] = None,
    evaluationRules: Option[Iterable[zio.aws.evidently.model.EvaluationRule]] =
      None,
    evaluationStrategy: zio.aws.evidently.model.FeatureEvaluationStrategy,
    lastUpdatedTime: Timestamp,
    name: FeatureName,
    project: Option[ProjectRef] = None,
    status: zio.aws.evidently.model.FeatureStatus,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.FeatureSummary = {
    import FeatureSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.FeatureSummary
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .createdTime(Timestamp.unwrap(createdTime): Instant)
      .optionallyWith(
        defaultVariation.map(value =>
          VariationName.unwrap(value): java.lang.String
        )
      )(_.defaultVariation)
      .optionallyWith(
        evaluationRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.evaluationRules)
      .evaluationStrategy(evaluationStrategy.unwrap)
      .lastUpdatedTime(Timestamp.unwrap(lastUpdatedTime): Instant)
      .name(FeatureName.unwrap(name): java.lang.String)
      .optionallyWith(
        project.map(value => ProjectRef.unwrap(value): java.lang.String)
      )(_.project)
      .status(status.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.FeatureSummary.ReadOnly =
    zio.aws.evidently.model.FeatureSummary.wrap(buildAwsValue())
}
object FeatureSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.FeatureSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.FeatureSummary =
      zio.aws.evidently.model.FeatureSummary(
        arn,
        createdTime,
        defaultVariation.map(value => value),
        evaluationRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        evaluationStrategy,
        lastUpdatedTime,
        name,
        project.map(value => value),
        status,
        tags.map(value => value)
      )
    def arn: Arn
    def createdTime: Timestamp
    def defaultVariation: Option[VariationName]
    def evaluationRules
        : Option[List[zio.aws.evidently.model.EvaluationRule.ReadOnly]]
    def evaluationStrategy: zio.aws.evidently.model.FeatureEvaluationStrategy
    def lastUpdatedTime: Timestamp
    def name: FeatureName
    def project: Option[ProjectRef]
    def status: zio.aws.evidently.model.FeatureStatus
    def tags: Option[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getCreatedTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdTime)
    def getDefaultVariation: ZIO[Any, AwsError, VariationName] =
      AwsError.unwrapOptionField("defaultVariation", defaultVariation)
    def getEvaluationRules: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.EvaluationRule.ReadOnly
    ]] = AwsError.unwrapOptionField("evaluationRules", evaluationRules)
    def getEvaluationStrategy
        : ZIO[Any, Nothing, zio.aws.evidently.model.FeatureEvaluationStrategy] =
      ZIO.succeed(evaluationStrategy)
    def getLastUpdatedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastUpdatedTime)
    def getName: ZIO[Any, Nothing, FeatureName] = ZIO.succeed(name)
    def getProject: ZIO[Any, AwsError, ProjectRef] =
      AwsError.unwrapOptionField("project", project)
    def getStatus: ZIO[Any, Nothing, zio.aws.evidently.model.FeatureStatus] =
      ZIO.succeed(status)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.FeatureSummary
  ) extends zio.aws.evidently.model.FeatureSummary.ReadOnly {
    override val arn: Arn = zio.aws.evidently.model.primitives.Arn(impl.arn())
    override val createdTime: Timestamp =
      zio.aws.evidently.model.primitives.Timestamp(impl.createdTime())
    override val defaultVariation: Option[VariationName] = scala
      .Option(impl.defaultVariation())
      .map(value => zio.aws.evidently.model.primitives.VariationName(value))
    override val evaluationRules
        : Option[List[zio.aws.evidently.model.EvaluationRule.ReadOnly]] = scala
      .Option(impl.evaluationRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.evidently.model.EvaluationRule.wrap(item)
        }.toList
      )
    override val evaluationStrategy
        : zio.aws.evidently.model.FeatureEvaluationStrategy =
      zio.aws.evidently.model.FeatureEvaluationStrategy
        .wrap(impl.evaluationStrategy())
    override val lastUpdatedTime: Timestamp =
      zio.aws.evidently.model.primitives.Timestamp(impl.lastUpdatedTime())
    override val name: FeatureName =
      zio.aws.evidently.model.primitives.FeatureName(impl.name())
    override val project: Option[ProjectRef] = scala
      .Option(impl.project())
      .map(value => zio.aws.evidently.model.primitives.ProjectRef(value))
    override val status: zio.aws.evidently.model.FeatureStatus =
      zio.aws.evidently.model.FeatureStatus.wrap(impl.status())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.evidently.model.primitives
              .TagKey(key) -> zio.aws.evidently.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.FeatureSummary
  ): zio.aws.evidently.model.FeatureSummary.ReadOnly = new Wrapper(impl)
}
