package zio.aws.evidently.model
import scala.jdk.CollectionConverters._
sealed trait FeatureStatus {
  def unwrap: software.amazon.awssdk.services.evidently.model.FeatureStatus
}
object FeatureStatus {
  def wrap(
      value: software.amazon.awssdk.services.evidently.model.FeatureStatus
  ): zio.aws.evidently.model.FeatureStatus = value match {
    case software.amazon.awssdk.services.evidently.model.FeatureStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.evidently.model.FeatureStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.evidently.model.FeatureStatus.UPDATING =>
      val r = UPDATING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.evidently.model.FeatureStatus {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.FeatureStatus =
      software.amazon.awssdk.services.evidently.model.FeatureStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object AVAILABLE extends zio.aws.evidently.model.FeatureStatus {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.FeatureStatus =
      software.amazon.awssdk.services.evidently.model.FeatureStatus.AVAILABLE
  }
  case object UPDATING extends zio.aws.evidently.model.FeatureStatus {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.FeatureStatus =
      software.amazon.awssdk.services.evidently.model.FeatureStatus.UPDATING
  }
}
