package zio.aws.evidently.model
import scala.jdk.CollectionConverters._
sealed trait ExperimentStopDesiredState {
  def unwrap: software.amazon.awssdk.services.evidently.model.ExperimentStopDesiredState
}
object ExperimentStopDesiredState {
  def wrap(
      value: software.amazon.awssdk.services.evidently.model.ExperimentStopDesiredState
  ): zio.aws.evidently.model.ExperimentStopDesiredState = value match {
    case software.amazon.awssdk.services.evidently.model.ExperimentStopDesiredState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.evidently.model.ExperimentStopDesiredState.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.evidently.model.ExperimentStopDesiredState.CANCELLED =>
      val r = CANCELLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.evidently.model.ExperimentStopDesiredState {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ExperimentStopDesiredState =
      software.amazon.awssdk.services.evidently.model.ExperimentStopDesiredState.UNKNOWN_TO_SDK_VERSION
  }
  case object COMPLETED
      extends zio.aws.evidently.model.ExperimentStopDesiredState {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ExperimentStopDesiredState =
      software.amazon.awssdk.services.evidently.model.ExperimentStopDesiredState.COMPLETED
  }
  case object CANCELLED
      extends zio.aws.evidently.model.ExperimentStopDesiredState {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ExperimentStopDesiredState =
      software.amazon.awssdk.services.evidently.model.ExperimentStopDesiredState.CANCELLED
  }
}
