package zio.aws.evidently.model
import scala.jdk.CollectionConverters._
sealed trait ExperimentResultResponseType {
  def unwrap: software.amazon.awssdk.services.evidently.model.ExperimentResultResponseType
}
object ExperimentResultResponseType {
  def wrap(
      value: software.amazon.awssdk.services.evidently.model.ExperimentResultResponseType
  ): zio.aws.evidently.model.ExperimentResultResponseType = value match {
    case software.amazon.awssdk.services.evidently.model.ExperimentResultResponseType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.evidently.model.ExperimentResultResponseType.MEAN =>
      val r = Mean
      r
    case software.amazon.awssdk.services.evidently.model.ExperimentResultResponseType.TREATMENT_EFFECT =>
      val r = TreatmentEffect
      r
    case software.amazon.awssdk.services.evidently.model.ExperimentResultResponseType.CONFIDENCE_INTERVAL_UPPER_BOUND =>
      val r = ConfidenceIntervalUpperBound
      r
    case software.amazon.awssdk.services.evidently.model.ExperimentResultResponseType.CONFIDENCE_INTERVAL_LOWER_BOUND =>
      val r = ConfidenceIntervalLowerBound
      r
    case software.amazon.awssdk.services.evidently.model.ExperimentResultResponseType.P_VALUE =>
      val r = PValue
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.evidently.model.ExperimentResultResponseType {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ExperimentResultResponseType =
      software.amazon.awssdk.services.evidently.model.ExperimentResultResponseType.UNKNOWN_TO_SDK_VERSION
  }
  case object Mean
      extends zio.aws.evidently.model.ExperimentResultResponseType {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ExperimentResultResponseType =
      software.amazon.awssdk.services.evidently.model.ExperimentResultResponseType.MEAN
  }
  case object TreatmentEffect
      extends zio.aws.evidently.model.ExperimentResultResponseType {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ExperimentResultResponseType =
      software.amazon.awssdk.services.evidently.model.ExperimentResultResponseType.TREATMENT_EFFECT
  }
  case object ConfidenceIntervalUpperBound
      extends zio.aws.evidently.model.ExperimentResultResponseType {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ExperimentResultResponseType =
      software.amazon.awssdk.services.evidently.model.ExperimentResultResponseType.CONFIDENCE_INTERVAL_UPPER_BOUND
  }
  case object ConfidenceIntervalLowerBound
      extends zio.aws.evidently.model.ExperimentResultResponseType {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ExperimentResultResponseType =
      software.amazon.awssdk.services.evidently.model.ExperimentResultResponseType.CONFIDENCE_INTERVAL_LOWER_BOUND
  }
  case object PValue
      extends zio.aws.evidently.model.ExperimentResultResponseType {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ExperimentResultResponseType =
      software.amazon.awssdk.services.evidently.model.ExperimentResultResponseType.P_VALUE
  }
}
