package zio.aws.evidently.model
import scala.jdk.CollectionConverters._
sealed trait ExperimentBaseStat {
  def unwrap: software.amazon.awssdk.services.evidently.model.ExperimentBaseStat
}
object ExperimentBaseStat {
  def wrap(
      value: software.amazon.awssdk.services.evidently.model.ExperimentBaseStat
  ): zio.aws.evidently.model.ExperimentBaseStat = value match {
    case software.amazon.awssdk.services.evidently.model.ExperimentBaseStat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.evidently.model.ExperimentBaseStat.MEAN =>
      val r = Mean
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.evidently.model.ExperimentBaseStat {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ExperimentBaseStat =
      software.amazon.awssdk.services.evidently.model.ExperimentBaseStat.UNKNOWN_TO_SDK_VERSION
  }
  case object Mean extends zio.aws.evidently.model.ExperimentBaseStat {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ExperimentBaseStat =
      software.amazon.awssdk.services.evidently.model.ExperimentBaseStat.MEAN
  }
}
