package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  SplitWeight,
  ExperimentArn,
  Timestamp,
  TagValue,
  ProjectArn,
  RandomizationSalt,
  Description,
  ExperimentName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Experiment(
    arn: ExperimentArn,
    createdTime: Timestamp,
    description: Option[Description] = None,
    execution: Option[zio.aws.evidently.model.ExperimentExecution] = None,
    lastUpdatedTime: Timestamp,
    metricGoals: Option[Iterable[zio.aws.evidently.model.MetricGoal]] = None,
    name: ExperimentName,
    onlineAbDefinition: Option[zio.aws.evidently.model.OnlineAbDefinition] =
      None,
    project: Option[ProjectArn] = None,
    randomizationSalt: Option[RandomizationSalt] = None,
    samplingRate: Option[SplitWeight] = None,
    schedule: Option[zio.aws.evidently.model.ExperimentSchedule] = None,
    status: zio.aws.evidently.model.ExperimentStatus,
    statusReason: Option[Description] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    treatments: Option[Iterable[zio.aws.evidently.model.Treatment]] = None,
    `type`: zio.aws.evidently.model.ExperimentType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.Experiment = {
    import Experiment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.Experiment
      .builder()
      .arn(ExperimentArn.unwrap(arn): java.lang.String)
      .createdTime(Timestamp.unwrap(createdTime): Instant)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(execution.map(value => value.buildAwsValue()))(
        _.execution
      )
      .lastUpdatedTime(Timestamp.unwrap(lastUpdatedTime): Instant)
      .optionallyWith(
        metricGoals.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricGoals)
      .name(ExperimentName.unwrap(name): java.lang.String)
      .optionallyWith(onlineAbDefinition.map(value => value.buildAwsValue()))(
        _.onlineAbDefinition
      )
      .optionallyWith(
        project.map(value => ProjectArn.unwrap(value): java.lang.String)
      )(_.project)
      .optionallyWith(
        randomizationSalt.map(value =>
          RandomizationSalt.unwrap(value): java.lang.String
        )
      )(_.randomizationSalt)
      .optionallyWith(
        samplingRate.map(value => SplitWeight.unwrap(value): java.lang.Long)
      )(_.samplingRate)
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .status(status.unwrap)
      .optionallyWith(
        statusReason.map(value => Description.unwrap(value): java.lang.String)
      )(_.statusReason)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        treatments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.treatments)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.Experiment.ReadOnly =
    zio.aws.evidently.model.Experiment.wrap(buildAwsValue())
}
object Experiment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.Experiment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.Experiment =
      zio.aws.evidently.model.Experiment(
        arn,
        createdTime,
        description.map(value => value),
        execution.map(value => value.asEditable),
        lastUpdatedTime,
        metricGoals.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name,
        onlineAbDefinition.map(value => value.asEditable),
        project.map(value => value),
        randomizationSalt.map(value => value),
        samplingRate.map(value => value),
        schedule.map(value => value.asEditable),
        status,
        statusReason.map(value => value),
        tags.map(value => value),
        treatments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        `type`
      )
    def arn: ExperimentArn
    def createdTime: Timestamp
    def description: Option[Description]
    def execution: Option[zio.aws.evidently.model.ExperimentExecution.ReadOnly]
    def lastUpdatedTime: Timestamp
    def metricGoals: Option[List[zio.aws.evidently.model.MetricGoal.ReadOnly]]
    def name: ExperimentName
    def onlineAbDefinition
        : Option[zio.aws.evidently.model.OnlineAbDefinition.ReadOnly]
    def project: Option[ProjectArn]
    def randomizationSalt: Option[RandomizationSalt]
    def samplingRate: Option[SplitWeight]
    def schedule: Option[zio.aws.evidently.model.ExperimentSchedule.ReadOnly]
    def status: zio.aws.evidently.model.ExperimentStatus
    def statusReason: Option[Description]
    def tags: Option[Map[TagKey, TagValue]]
    def treatments: Option[List[zio.aws.evidently.model.Treatment.ReadOnly]]
    def `type`: zio.aws.evidently.model.ExperimentType
    def getArn: ZIO[Any, Nothing, ExperimentArn] = ZIO.succeed(arn)
    def getCreatedTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdTime)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getExecution: ZIO[
      Any,
      AwsError,
      zio.aws.evidently.model.ExperimentExecution.ReadOnly
    ] = AwsError.unwrapOptionField("execution", execution)
    def getLastUpdatedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastUpdatedTime)
    def getMetricGoals: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.MetricGoal.ReadOnly
    ]] = AwsError.unwrapOptionField("metricGoals", metricGoals)
    def getName: ZIO[Any, Nothing, ExperimentName] = ZIO.succeed(name)
    def getOnlineAbDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.evidently.model.OnlineAbDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("onlineAbDefinition", onlineAbDefinition)
    def getProject: ZIO[Any, AwsError, ProjectArn] =
      AwsError.unwrapOptionField("project", project)
    def getRandomizationSalt: ZIO[Any, AwsError, RandomizationSalt] =
      AwsError.unwrapOptionField("randomizationSalt", randomizationSalt)
    def getSamplingRate: ZIO[Any, AwsError, SplitWeight] =
      AwsError.unwrapOptionField("samplingRate", samplingRate)
    def getSchedule: ZIO[
      Any,
      AwsError,
      zio.aws.evidently.model.ExperimentSchedule.ReadOnly
    ] = AwsError.unwrapOptionField("schedule", schedule)
    def getStatus: ZIO[Any, Nothing, zio.aws.evidently.model.ExperimentStatus] =
      ZIO.succeed(status)
    def getStatusReason: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTreatments
        : ZIO[Any, AwsError, List[zio.aws.evidently.model.Treatment.ReadOnly]] =
      AwsError.unwrapOptionField("treatments", treatments)
    def getType: ZIO[Any, Nothing, zio.aws.evidently.model.ExperimentType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.Experiment
  ) extends zio.aws.evidently.model.Experiment.ReadOnly {
    override val arn: ExperimentArn =
      zio.aws.evidently.model.primitives.ExperimentArn(impl.arn())
    override val createdTime: Timestamp =
      zio.aws.evidently.model.primitives.Timestamp(impl.createdTime())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.evidently.model.primitives.Description(value))
    override val execution
        : Option[zio.aws.evidently.model.ExperimentExecution.ReadOnly] = scala
      .Option(impl.execution())
      .map(value => zio.aws.evidently.model.ExperimentExecution.wrap(value))
    override val lastUpdatedTime: Timestamp =
      zio.aws.evidently.model.primitives.Timestamp(impl.lastUpdatedTime())
    override val metricGoals
        : Option[List[zio.aws.evidently.model.MetricGoal.ReadOnly]] = scala
      .Option(impl.metricGoals())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.evidently.model.MetricGoal.wrap(item)
        }.toList
      )
    override val name: ExperimentName =
      zio.aws.evidently.model.primitives.ExperimentName(impl.name())
    override val onlineAbDefinition
        : Option[zio.aws.evidently.model.OnlineAbDefinition.ReadOnly] = scala
      .Option(impl.onlineAbDefinition())
      .map(value => zio.aws.evidently.model.OnlineAbDefinition.wrap(value))
    override val project: Option[ProjectArn] = scala
      .Option(impl.project())
      .map(value => zio.aws.evidently.model.primitives.ProjectArn(value))
    override val randomizationSalt: Option[RandomizationSalt] = scala
      .Option(impl.randomizationSalt())
      .map(value => zio.aws.evidently.model.primitives.RandomizationSalt(value))
    override val samplingRate: Option[SplitWeight] = scala
      .Option(impl.samplingRate())
      .map(value => zio.aws.evidently.model.primitives.SplitWeight(value))
    override val schedule
        : Option[zio.aws.evidently.model.ExperimentSchedule.ReadOnly] = scala
      .Option(impl.schedule())
      .map(value => zio.aws.evidently.model.ExperimentSchedule.wrap(value))
    override val status: zio.aws.evidently.model.ExperimentStatus =
      zio.aws.evidently.model.ExperimentStatus.wrap(impl.status())
    override val statusReason: Option[Description] = scala
      .Option(impl.statusReason())
      .map(value => zio.aws.evidently.model.primitives.Description(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.evidently.model.primitives
              .TagKey(key) -> zio.aws.evidently.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val treatments
        : Option[List[zio.aws.evidently.model.Treatment.ReadOnly]] = scala
      .Option(impl.treatments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.evidently.model.Treatment.wrap(item)
        }.toList
      )
    override val `type`: zio.aws.evidently.model.ExperimentType =
      zio.aws.evidently.model.ExperimentType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.Experiment
  ): zio.aws.evidently.model.Experiment.ReadOnly = new Wrapper(impl)
}
