package zio.aws.evidently.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchEvaluateFeatureResponse(
    results: Option[Iterable[zio.aws.evidently.model.EvaluationResult]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.BatchEvaluateFeatureResponse = {
    import BatchEvaluateFeatureResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.BatchEvaluateFeatureResponse
      .builder()
      .optionallyWith(
        results.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.results)
      .build()
  }
  def asReadOnly
      : zio.aws.evidently.model.BatchEvaluateFeatureResponse.ReadOnly =
    zio.aws.evidently.model.BatchEvaluateFeatureResponse.wrap(buildAwsValue())
}
object BatchEvaluateFeatureResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.BatchEvaluateFeatureResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.BatchEvaluateFeatureResponse =
      zio.aws.evidently.model.BatchEvaluateFeatureResponse(
        results.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def results: Option[List[zio.aws.evidently.model.EvaluationResult.ReadOnly]]
    def getResults: ZIO[Any, AwsError, List[
      zio.aws.evidently.model.EvaluationResult.ReadOnly
    ]] = AwsError.unwrapOptionField("results", results)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.BatchEvaluateFeatureResponse
  ) extends zio.aws.evidently.model.BatchEvaluateFeatureResponse.ReadOnly {
    override val results
        : Option[List[zio.aws.evidently.model.EvaluationResult.ReadOnly]] =
      scala
        .Option(impl.results())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.evidently.model.EvaluationResult.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.BatchEvaluateFeatureResponse
  ): zio.aws.evidently.model.BatchEvaluateFeatureResponse.ReadOnly =
    new Wrapper(impl)
}
