package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StopExperimentResponse(endedTime: Option[Timestamp] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.StopExperimentResponse = {
    import StopExperimentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.StopExperimentResponse
      .builder()
      .optionallyWith(endedTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endedTime
      )
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.StopExperimentResponse.ReadOnly =
    zio.aws.evidently.model.StopExperimentResponse.wrap(buildAwsValue())
}
object StopExperimentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.StopExperimentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.StopExperimentResponse =
      zio.aws.evidently.model
        .StopExperimentResponse(endedTime.map(value => value))
    def endedTime: Option[Timestamp]
    def getEndedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endedTime", endedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.StopExperimentResponse
  ) extends zio.aws.evidently.model.StopExperimentResponse.ReadOnly {
    override val endedTime: Option[Timestamp] = scala
      .Option(impl.endedTime())
      .map(value => zio.aws.evidently.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.StopExperimentResponse
  ): zio.aws.evidently.model.StopExperimentResponse.ReadOnly = new Wrapper(impl)
}
