package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{Timestamp, SplitWeight, GroupName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ScheduledSplit(
    groupWeights: Option[Map[GroupName, SplitWeight]] = None,
    startTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ScheduledSplit = {
    import ScheduledSplit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ScheduledSplit
      .builder()
      .optionallyWith(
        groupWeights.map(value =>
          value
            .map({ case (key, value) =>
              (GroupName.unwrap(key): java.lang.String) -> (SplitWeight
                .unwrap(value): java.lang.Long)
            })
            .asJava
        )
      )(_.groupWeights)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.ScheduledSplit.ReadOnly =
    zio.aws.evidently.model.ScheduledSplit.wrap(buildAwsValue())
}
object ScheduledSplit {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ScheduledSplit
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ScheduledSplit =
      zio.aws.evidently.model
        .ScheduledSplit(groupWeights.map(value => value), startTime)
    def groupWeights: Option[Map[GroupName, SplitWeight]]
    def startTime: Timestamp
    def getGroupWeights: ZIO[Any, AwsError, Map[GroupName, SplitWeight]] =
      AwsError.unwrapOptionField("groupWeights", groupWeights)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ScheduledSplit
  ) extends zio.aws.evidently.model.ScheduledSplit.ReadOnly {
    override val groupWeights: Option[Map[GroupName, SplitWeight]] = scala
      .Option(impl.groupWeights())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.evidently.model.primitives.GroupName(
              key
            ) -> zio.aws.evidently.model.primitives.SplitWeight(value)
          })
          .toMap
      )
    override val startTime: Timestamp =
      zio.aws.evidently.model.primitives.Timestamp(impl.startTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ScheduledSplit
  ): zio.aws.evidently.model.ScheduledSplit.ReadOnly = new Wrapper(impl)
}
