package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{SplitWeight, TreatmentName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class OnlineAbDefinition(
    controlTreatmentName: Option[TreatmentName] = None,
    treatmentWeights: Option[Map[TreatmentName, SplitWeight]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.OnlineAbDefinition = {
    import OnlineAbDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.OnlineAbDefinition
      .builder()
      .optionallyWith(
        controlTreatmentName.map(value =>
          TreatmentName.unwrap(value): java.lang.String
        )
      )(_.controlTreatmentName)
      .optionallyWith(
        treatmentWeights.map(value =>
          value
            .map({ case (key, value) =>
              (TreatmentName.unwrap(key): java.lang.String) -> (SplitWeight
                .unwrap(value): java.lang.Long)
            })
            .asJava
        )
      )(_.treatmentWeights)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.OnlineAbDefinition.ReadOnly =
    zio.aws.evidently.model.OnlineAbDefinition.wrap(buildAwsValue())
}
object OnlineAbDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.OnlineAbDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.OnlineAbDefinition =
      zio.aws.evidently.model.OnlineAbDefinition(
        controlTreatmentName.map(value => value),
        treatmentWeights.map(value => value)
      )
    def controlTreatmentName: Option[TreatmentName]
    def treatmentWeights: Option[Map[TreatmentName, SplitWeight]]
    def getControlTreatmentName: ZIO[Any, AwsError, TreatmentName] =
      AwsError.unwrapOptionField("controlTreatmentName", controlTreatmentName)
    def getTreatmentWeights
        : ZIO[Any, AwsError, Map[TreatmentName, SplitWeight]] =
      AwsError.unwrapOptionField("treatmentWeights", treatmentWeights)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.OnlineAbDefinition
  ) extends zio.aws.evidently.model.OnlineAbDefinition.ReadOnly {
    override val controlTreatmentName: Option[TreatmentName] = scala
      .Option(impl.controlTreatmentName())
      .map(value => zio.aws.evidently.model.primitives.TreatmentName(value))
    override val treatmentWeights: Option[Map[TreatmentName, SplitWeight]] =
      scala
        .Option(impl.treatmentWeights())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.evidently.model.primitives.TreatmentName(
                key
              ) -> zio.aws.evidently.model.primitives.SplitWeight(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.OnlineAbDefinition
  ): zio.aws.evidently.model.OnlineAbDefinition.ReadOnly = new Wrapper(impl)
}
