package zio.aws.evidently.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MetricGoalConfig(
    desiredChange: Option[zio.aws.evidently.model.ChangeDirectionEnum] = None,
    metricDefinition: zio.aws.evidently.model.MetricDefinitionConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.MetricGoalConfig = {
    import MetricGoalConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.MetricGoalConfig
      .builder()
      .optionallyWith(desiredChange.map(value => value.unwrap))(_.desiredChange)
      .metricDefinition(metricDefinition.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.MetricGoalConfig.ReadOnly =
    zio.aws.evidently.model.MetricGoalConfig.wrap(buildAwsValue())
}
object MetricGoalConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.MetricGoalConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.MetricGoalConfig =
      zio.aws.evidently.model.MetricGoalConfig(
        desiredChange.map(value => value),
        metricDefinition.asEditable
      )
    def desiredChange: Option[zio.aws.evidently.model.ChangeDirectionEnum]
    def metricDefinition
        : zio.aws.evidently.model.MetricDefinitionConfig.ReadOnly
    def getDesiredChange
        : ZIO[Any, AwsError, zio.aws.evidently.model.ChangeDirectionEnum] =
      AwsError.unwrapOptionField("desiredChange", desiredChange)
    def getMetricDefinition: ZIO[
      Any,
      Nothing,
      zio.aws.evidently.model.MetricDefinitionConfig.ReadOnly
    ] = ZIO.succeed(metricDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.MetricGoalConfig
  ) extends zio.aws.evidently.model.MetricGoalConfig.ReadOnly {
    override val desiredChange
        : Option[zio.aws.evidently.model.ChangeDirectionEnum] = scala
      .Option(impl.desiredChange())
      .map(value => zio.aws.evidently.model.ChangeDirectionEnum.wrap(value))
    override val metricDefinition
        : zio.aws.evidently.model.MetricDefinitionConfig.ReadOnly =
      zio.aws.evidently.model.MetricDefinitionConfig
        .wrap(impl.metricDefinition())
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.MetricGoalConfig
  ): zio.aws.evidently.model.MetricGoalConfig.ReadOnly = new Wrapper(impl)
}
