package zio.aws.evidently.model
import java.lang.Integer
import zio.aws.evidently.model.primitives.{NextToken, MaxProjects}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListProjectsRequest(
    maxResults: Option[MaxProjects] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ListProjectsRequest = {
    import ListProjectsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ListProjectsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxProjects.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.ListProjectsRequest.ReadOnly =
    zio.aws.evidently.model.ListProjectsRequest.wrap(buildAwsValue())
}
object ListProjectsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ListProjectsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ListProjectsRequest =
      zio.aws.evidently.model.ListProjectsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Option[MaxProjects]
    def nextToken: Option[NextToken]
    def getMaxResults: ZIO[Any, AwsError, MaxProjects] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ListProjectsRequest
  ) extends zio.aws.evidently.model.ListProjectsRequest.ReadOnly {
    override val maxResults: Option[MaxProjects] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.evidently.model.primitives.MaxProjects(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.evidently.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ListProjectsRequest
  ): zio.aws.evidently.model.ListProjectsRequest.ReadOnly = new Wrapper(impl)
}
