package zio.aws.evidently.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetLaunchResponse(
    launch: Option[zio.aws.evidently.model.Launch] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.GetLaunchResponse = {
    import GetLaunchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.GetLaunchResponse
      .builder()
      .optionallyWith(launch.map(value => value.buildAwsValue()))(_.launch)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.GetLaunchResponse.ReadOnly =
    zio.aws.evidently.model.GetLaunchResponse.wrap(buildAwsValue())
}
object GetLaunchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.GetLaunchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.GetLaunchResponse =
      zio.aws.evidently.model
        .GetLaunchResponse(launch.map(value => value.asEditable))
    def launch: Option[zio.aws.evidently.model.Launch.ReadOnly]
    def getLaunch: ZIO[Any, AwsError, zio.aws.evidently.model.Launch.ReadOnly] =
      AwsError.unwrapOptionField("launch", launch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.GetLaunchResponse
  ) extends zio.aws.evidently.model.GetLaunchResponse.ReadOnly {
    override val launch: Option[zio.aws.evidently.model.Launch.ReadOnly] = scala
      .Option(impl.launch())
      .map(value => zio.aws.evidently.model.Launch.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.GetLaunchResponse
  ): zio.aws.evidently.model.GetLaunchResponse.ReadOnly = new Wrapper(impl)
}
