package zio.aws.evidently.model
import scala.jdk.CollectionConverters._
sealed trait FeatureEvaluationStrategy {
  def unwrap: software.amazon.awssdk.services.evidently.model.FeatureEvaluationStrategy
}
object FeatureEvaluationStrategy {
  def wrap(
      value: software.amazon.awssdk.services.evidently.model.FeatureEvaluationStrategy
  ): zio.aws.evidently.model.FeatureEvaluationStrategy = value match {
    case software.amazon.awssdk.services.evidently.model.FeatureEvaluationStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.evidently.model.FeatureEvaluationStrategy.ALL_RULES =>
      val r = ALL_RULES
      r
    case software.amazon.awssdk.services.evidently.model.FeatureEvaluationStrategy.DEFAULT_VARIATION =>
      val r = DEFAULT_VARIATION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.evidently.model.FeatureEvaluationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.FeatureEvaluationStrategy =
      software.amazon.awssdk.services.evidently.model.FeatureEvaluationStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL_RULES
      extends zio.aws.evidently.model.FeatureEvaluationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.FeatureEvaluationStrategy =
      software.amazon.awssdk.services.evidently.model.FeatureEvaluationStrategy.ALL_RULES
  }
  case object DEFAULT_VARIATION
      extends zio.aws.evidently.model.FeatureEvaluationStrategy {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.FeatureEvaluationStrategy =
      software.amazon.awssdk.services.evidently.model.FeatureEvaluationStrategy.DEFAULT_VARIATION
  }
}
