package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ExperimentSchedule(
    analysisCompleteTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.ExperimentSchedule = {
    import ExperimentSchedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.ExperimentSchedule
      .builder()
      .optionallyWith(
        analysisCompleteTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.analysisCompleteTime)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.ExperimentSchedule.ReadOnly =
    zio.aws.evidently.model.ExperimentSchedule.wrap(buildAwsValue())
}
object ExperimentSchedule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.ExperimentSchedule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.ExperimentSchedule =
      zio.aws.evidently.model
        .ExperimentSchedule(analysisCompleteTime.map(value => value))
    def analysisCompleteTime: Option[Timestamp]
    def getAnalysisCompleteTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("analysisCompleteTime", analysisCompleteTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.ExperimentSchedule
  ) extends zio.aws.evidently.model.ExperimentSchedule.ReadOnly {
    override val analysisCompleteTime: Option[Timestamp] = scala
      .Option(impl.analysisCompleteTime())
      .map(value => zio.aws.evidently.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.ExperimentSchedule
  ): zio.aws.evidently.model.ExperimentSchedule.ReadOnly = new Wrapper(impl)
}
