package zio.aws.evidently.model
import scala.jdk.CollectionConverters._
sealed trait ExperimentReportName {
  def unwrap
      : software.amazon.awssdk.services.evidently.model.ExperimentReportName
}
object ExperimentReportName {
  def wrap(
      value: software.amazon.awssdk.services.evidently.model.ExperimentReportName
  ): zio.aws.evidently.model.ExperimentReportName = value match {
    case software.amazon.awssdk.services.evidently.model.ExperimentReportName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.evidently.model.ExperimentReportName.BAYESIAN_INFERENCE =>
      val r = BayesianInference
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.evidently.model.ExperimentReportName {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ExperimentReportName =
      software.amazon.awssdk.services.evidently.model.ExperimentReportName.UNKNOWN_TO_SDK_VERSION
  }
  case object BayesianInference
      extends zio.aws.evidently.model.ExperimentReportName {
    override def unwrap
        : software.amazon.awssdk.services.evidently.model.ExperimentReportName =
      software.amazon.awssdk.services.evidently.model.ExperimentReportName.BAYESIAN_INFERENCE
  }
}
