package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  TagValue,
  TagKey,
  ProjectName,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateProjectRequest(
    dataDelivery: Option[zio.aws.evidently.model.ProjectDataDeliveryConfig] =
      None,
    description: Option[Description] = None,
    name: ProjectName,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.CreateProjectRequest = {
    import CreateProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.CreateProjectRequest
      .builder()
      .optionallyWith(dataDelivery.map(value => value.buildAwsValue()))(
        _.dataDelivery
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .name(ProjectName.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.CreateProjectRequest.ReadOnly =
    zio.aws.evidently.model.CreateProjectRequest.wrap(buildAwsValue())
}
object CreateProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.CreateProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.CreateProjectRequest =
      zio.aws.evidently.model.CreateProjectRequest(
        dataDelivery.map(value => value.asEditable),
        description.map(value => value),
        name,
        tags.map(value => value)
      )
    def dataDelivery
        : Option[zio.aws.evidently.model.ProjectDataDeliveryConfig.ReadOnly]
    def description: Option[Description]
    def name: ProjectName
    def tags: Option[Map[TagKey, TagValue]]
    def getDataDelivery: ZIO[
      Any,
      AwsError,
      zio.aws.evidently.model.ProjectDataDeliveryConfig.ReadOnly
    ] = AwsError.unwrapOptionField("dataDelivery", dataDelivery)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, ProjectName] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.CreateProjectRequest
  ) extends zio.aws.evidently.model.CreateProjectRequest.ReadOnly {
    override val dataDelivery
        : Option[zio.aws.evidently.model.ProjectDataDeliveryConfig.ReadOnly] =
      scala
        .Option(impl.dataDelivery())
        .map(value =>
          zio.aws.evidently.model.ProjectDataDeliveryConfig.wrap(value)
        )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.evidently.model.primitives.Description(value))
    override val name: ProjectName =
      zio.aws.evidently.model.primitives.ProjectName(impl.name())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.evidently.model.primitives
              .TagKey(key) -> zio.aws.evidently.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.CreateProjectRequest
  ): zio.aws.evidently.model.CreateProjectRequest.ReadOnly = new Wrapper(impl)
}
