package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  VariationName,
  TagValue,
  ProjectRef,
  Description,
  EntityId,
  FeatureName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateFeatureRequest(
    defaultVariation: Option[VariationName] = None,
    description: Option[Description] = None,
    entityOverrides: Option[Map[EntityId, VariationName]] = None,
    evaluationStrategy: Option[
      zio.aws.evidently.model.FeatureEvaluationStrategy
    ] = None,
    name: FeatureName,
    project: ProjectRef,
    tags: Option[Map[TagKey, TagValue]] = None,
    variations: Iterable[zio.aws.evidently.model.VariationConfig]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.CreateFeatureRequest = {
    import CreateFeatureRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.CreateFeatureRequest
      .builder()
      .optionallyWith(
        defaultVariation.map(value =>
          VariationName.unwrap(value): java.lang.String
        )
      )(_.defaultVariation)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        entityOverrides.map(value =>
          value
            .map({ case (key, value) =>
              (EntityId.unwrap(key): java.lang.String) -> (VariationName.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.entityOverrides)
      .optionallyWith(evaluationStrategy.map(value => value.unwrap))(
        _.evaluationStrategy
      )
      .name(FeatureName.unwrap(name): java.lang.String)
      .project(ProjectRef.unwrap(project): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .variations(variations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.CreateFeatureRequest.ReadOnly =
    zio.aws.evidently.model.CreateFeatureRequest.wrap(buildAwsValue())
}
object CreateFeatureRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.CreateFeatureRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.CreateFeatureRequest =
      zio.aws.evidently.model.CreateFeatureRequest(
        defaultVariation.map(value => value),
        description.map(value => value),
        entityOverrides.map(value => value),
        evaluationStrategy.map(value => value),
        name,
        project,
        tags.map(value => value),
        variations.map { item =>
          item.asEditable
        }
      )
    def defaultVariation: Option[VariationName]
    def description: Option[Description]
    def entityOverrides: Option[Map[EntityId, VariationName]]
    def evaluationStrategy
        : Option[zio.aws.evidently.model.FeatureEvaluationStrategy]
    def name: FeatureName
    def project: ProjectRef
    def tags: Option[Map[TagKey, TagValue]]
    def variations: List[zio.aws.evidently.model.VariationConfig.ReadOnly]
    def getDefaultVariation: ZIO[Any, AwsError, VariationName] =
      AwsError.unwrapOptionField("defaultVariation", defaultVariation)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEntityOverrides: ZIO[Any, AwsError, Map[EntityId, VariationName]] =
      AwsError.unwrapOptionField("entityOverrides", entityOverrides)
    def getEvaluationStrategy: ZIO[
      Any,
      AwsError,
      zio.aws.evidently.model.FeatureEvaluationStrategy
    ] = AwsError.unwrapOptionField("evaluationStrategy", evaluationStrategy)
    def getName: ZIO[Any, Nothing, FeatureName] = ZIO.succeed(name)
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVariations: ZIO[Any, Nothing, List[
      zio.aws.evidently.model.VariationConfig.ReadOnly
    ]] = ZIO.succeed(variations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.CreateFeatureRequest
  ) extends zio.aws.evidently.model.CreateFeatureRequest.ReadOnly {
    override val defaultVariation: Option[VariationName] = scala
      .Option(impl.defaultVariation())
      .map(value => zio.aws.evidently.model.primitives.VariationName(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.evidently.model.primitives.Description(value))
    override val entityOverrides: Option[Map[EntityId, VariationName]] = scala
      .Option(impl.entityOverrides())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.evidently.model.primitives.EntityId(
              key
            ) -> zio.aws.evidently.model.primitives.VariationName(value)
          })
          .toMap
      )
    override val evaluationStrategy
        : Option[zio.aws.evidently.model.FeatureEvaluationStrategy] = scala
      .Option(impl.evaluationStrategy())
      .map(value =>
        zio.aws.evidently.model.FeatureEvaluationStrategy.wrap(value)
      )
    override val name: FeatureName =
      zio.aws.evidently.model.primitives.FeatureName(impl.name())
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.evidently.model.primitives
              .TagKey(key) -> zio.aws.evidently.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val variations
        : List[zio.aws.evidently.model.VariationConfig.ReadOnly] = impl
      .variations()
      .asScala
      .map { item =>
        zio.aws.evidently.model.VariationConfig.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.CreateFeatureRequest
  ): zio.aws.evidently.model.CreateFeatureRequest.ReadOnly = new Wrapper(impl)
}
