package zio.aws.evidently.model
import zio.aws.evidently.model.primitives.{
  SplitWeight,
  TagValue,
  ProjectRef,
  RandomizationSalt,
  Description,
  ExperimentName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateExperimentRequest(
    description: Option[Description] = None,
    metricGoals: Iterable[zio.aws.evidently.model.MetricGoalConfig],
    name: ExperimentName,
    onlineAbConfig: Option[zio.aws.evidently.model.OnlineAbConfig] = None,
    project: ProjectRef,
    randomizationSalt: Option[RandomizationSalt] = None,
    samplingRate: Option[SplitWeight] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    treatments: Iterable[zio.aws.evidently.model.TreatmentConfig]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.evidently.model.CreateExperimentRequest = {
    import CreateExperimentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.evidently.model.CreateExperimentRequest
      .builder()
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .metricGoals(metricGoals.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .name(ExperimentName.unwrap(name): java.lang.String)
      .optionallyWith(onlineAbConfig.map(value => value.buildAwsValue()))(
        _.onlineAbConfig
      )
      .project(ProjectRef.unwrap(project): java.lang.String)
      .optionallyWith(
        randomizationSalt.map(value =>
          RandomizationSalt.unwrap(value): java.lang.String
        )
      )(_.randomizationSalt)
      .optionallyWith(
        samplingRate.map(value => SplitWeight.unwrap(value): java.lang.Long)
      )(_.samplingRate)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .treatments(treatments.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.evidently.model.CreateExperimentRequest.ReadOnly =
    zio.aws.evidently.model.CreateExperimentRequest.wrap(buildAwsValue())
}
object CreateExperimentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.evidently.model.CreateExperimentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.evidently.model.CreateExperimentRequest =
      zio.aws.evidently.model.CreateExperimentRequest(
        description.map(value => value),
        metricGoals.map { item =>
          item.asEditable
        },
        name,
        onlineAbConfig.map(value => value.asEditable),
        project,
        randomizationSalt.map(value => value),
        samplingRate.map(value => value),
        tags.map(value => value),
        treatments.map { item =>
          item.asEditable
        }
      )
    def description: Option[Description]
    def metricGoals: List[zio.aws.evidently.model.MetricGoalConfig.ReadOnly]
    def name: ExperimentName
    def onlineAbConfig: Option[zio.aws.evidently.model.OnlineAbConfig.ReadOnly]
    def project: ProjectRef
    def randomizationSalt: Option[RandomizationSalt]
    def samplingRate: Option[SplitWeight]
    def tags: Option[Map[TagKey, TagValue]]
    def treatments: List[zio.aws.evidently.model.TreatmentConfig.ReadOnly]
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getMetricGoals: ZIO[Any, Nothing, List[
      zio.aws.evidently.model.MetricGoalConfig.ReadOnly
    ]] = ZIO.succeed(metricGoals)
    def getName: ZIO[Any, Nothing, ExperimentName] = ZIO.succeed(name)
    def getOnlineAbConfig
        : ZIO[Any, AwsError, zio.aws.evidently.model.OnlineAbConfig.ReadOnly] =
      AwsError.unwrapOptionField("onlineAbConfig", onlineAbConfig)
    def getProject: ZIO[Any, Nothing, ProjectRef] = ZIO.succeed(project)
    def getRandomizationSalt: ZIO[Any, AwsError, RandomizationSalt] =
      AwsError.unwrapOptionField("randomizationSalt", randomizationSalt)
    def getSamplingRate: ZIO[Any, AwsError, SplitWeight] =
      AwsError.unwrapOptionField("samplingRate", samplingRate)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTreatments: ZIO[Any, Nothing, List[
      zio.aws.evidently.model.TreatmentConfig.ReadOnly
    ]] = ZIO.succeed(treatments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.evidently.model.CreateExperimentRequest
  ) extends zio.aws.evidently.model.CreateExperimentRequest.ReadOnly {
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.evidently.model.primitives.Description(value))
    override val metricGoals
        : List[zio.aws.evidently.model.MetricGoalConfig.ReadOnly] = impl
      .metricGoals()
      .asScala
      .map { item =>
        zio.aws.evidently.model.MetricGoalConfig.wrap(item)
      }
      .toList
    override val name: ExperimentName =
      zio.aws.evidently.model.primitives.ExperimentName(impl.name())
    override val onlineAbConfig
        : Option[zio.aws.evidently.model.OnlineAbConfig.ReadOnly] = scala
      .Option(impl.onlineAbConfig())
      .map(value => zio.aws.evidently.model.OnlineAbConfig.wrap(value))
    override val project: ProjectRef =
      zio.aws.evidently.model.primitives.ProjectRef(impl.project())
    override val randomizationSalt: Option[RandomizationSalt] = scala
      .Option(impl.randomizationSalt())
      .map(value => zio.aws.evidently.model.primitives.RandomizationSalt(value))
    override val samplingRate: Option[SplitWeight] = scala
      .Option(impl.samplingRate())
      .map(value => zio.aws.evidently.model.primitives.SplitWeight(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.evidently.model.primitives
              .TagKey(key) -> zio.aws.evidently.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val treatments
        : List[zio.aws.evidently.model.TreatmentConfig.ReadOnly] = impl
      .treatments()
      .asScala
      .map { item =>
        zio.aws.evidently.model.TreatmentConfig.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.evidently.model.CreateExperimentRequest
  ): zio.aws.evidently.model.CreateExperimentRequest.ReadOnly = new Wrapper(
    impl
  )
}
