package zio.aws.eventbridge
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.eventbridge.model.primitives.{
  QueryStringKey,
  EventResource,
  QueryStringValue,
  InputTransformerPathKey,
  Arn,
  RuleName,
  HeaderKey,
  PathParameter,
  TargetId,
  HeaderValue,
  TargetInputPath,
  RunCommandTargetValue,
  TagKey
}
import zio.aws.eventbridge.model.primitives.AuthHeaderParameters.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AccountId extends Subtype[String]
    type AccountId = zio.aws.eventbridge.model.primitives.AccountId.Type
    object Action extends Subtype[String]
    type Action = zio.aws.eventbridge.model.primitives.Action.Type
    object ApiDestinationArn extends Subtype[String]
    type ApiDestinationArn =
      zio.aws.eventbridge.model.primitives.ApiDestinationArn.Type
    object ApiDestinationDescription extends Subtype[String]
    type ApiDestinationDescription =
      zio.aws.eventbridge.model.primitives.ApiDestinationDescription.Type
    object ApiDestinationInvocationRateLimitPerSecond extends Subtype[Int]
    type ApiDestinationInvocationRateLimitPerSecond =
      zio.aws.eventbridge.model.primitives.ApiDestinationInvocationRateLimitPerSecond.Type
    object ApiDestinationName extends Subtype[String]
    type ApiDestinationName =
      zio.aws.eventbridge.model.primitives.ApiDestinationName.Type
    object ArchiveArn extends Subtype[String]
    type ArchiveArn = zio.aws.eventbridge.model.primitives.ArchiveArn.Type
    object ArchiveDescription extends Subtype[String]
    type ArchiveDescription =
      zio.aws.eventbridge.model.primitives.ArchiveDescription.Type
    object ArchiveName extends Subtype[String]
    type ArchiveName = zio.aws.eventbridge.model.primitives.ArchiveName.Type
    object ArchiveStateReason extends Subtype[String]
    type ArchiveStateReason =
      zio.aws.eventbridge.model.primitives.ArchiveStateReason.Type
    object Arn extends Subtype[String]
    type Arn = zio.aws.eventbridge.model.primitives.Arn.Type
    object AuthHeaderParameters extends Subtype[String]
    type AuthHeaderParameters =
      zio.aws.eventbridge.model.primitives.AuthHeaderParameters.Type
    object CapacityProvider extends Subtype[String]
    type CapacityProvider =
      zio.aws.eventbridge.model.primitives.CapacityProvider.Type
    object CapacityProviderStrategyItemBase extends Subtype[Int]
    type CapacityProviderStrategyItemBase =
      zio.aws.eventbridge.model.primitives.CapacityProviderStrategyItemBase.Type
    object CapacityProviderStrategyItemWeight extends Subtype[Int]
    type CapacityProviderStrategyItemWeight =
      zio.aws.eventbridge.model.primitives.CapacityProviderStrategyItemWeight.Type
    object ConnectionArn extends Subtype[String]
    type ConnectionArn = zio.aws.eventbridge.model.primitives.ConnectionArn.Type
    object ConnectionDescription extends Subtype[String]
    type ConnectionDescription =
      zio.aws.eventbridge.model.primitives.ConnectionDescription.Type
    object ConnectionName extends Subtype[String]
    type ConnectionName =
      zio.aws.eventbridge.model.primitives.ConnectionName.Type
    object ConnectionStateReason extends Subtype[String]
    type ConnectionStateReason =
      zio.aws.eventbridge.model.primitives.ConnectionStateReason.Type
    object CreatedBy extends Subtype[String]
    type CreatedBy = zio.aws.eventbridge.model.primitives.CreatedBy.Type
    object Database extends Subtype[String]
    type Database = zio.aws.eventbridge.model.primitives.Database.Type
    object DbUser extends Subtype[String]
    type DbUser = zio.aws.eventbridge.model.primitives.DbUser.Type
    object EndpointArn extends Subtype[String]
    type EndpointArn = zio.aws.eventbridge.model.primitives.EndpointArn.Type
    object EndpointDescription extends Subtype[String]
    type EndpointDescription =
      zio.aws.eventbridge.model.primitives.EndpointDescription.Type
    object EndpointId extends Subtype[String]
    type EndpointId = zio.aws.eventbridge.model.primitives.EndpointId.Type
    object EndpointName extends Subtype[String]
    type EndpointName = zio.aws.eventbridge.model.primitives.EndpointName.Type
    object EndpointStateReason extends Subtype[String]
    type EndpointStateReason =
      zio.aws.eventbridge.model.primitives.EndpointStateReason.Type
    object EndpointUrl extends Subtype[String]
    type EndpointUrl = zio.aws.eventbridge.model.primitives.EndpointUrl.Type
    object ErrorCode extends Subtype[String]
    type ErrorCode = zio.aws.eventbridge.model.primitives.ErrorCode.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.eventbridge.model.primitives.ErrorMessage.Type
    object EventBusName extends Subtype[String]
    type EventBusName = zio.aws.eventbridge.model.primitives.EventBusName.Type
    object EventBusNameOrArn extends Subtype[String]
    type EventBusNameOrArn =
      zio.aws.eventbridge.model.primitives.EventBusNameOrArn.Type
    object EventId extends Subtype[String]
    type EventId = zio.aws.eventbridge.model.primitives.EventId.Type
    object EventPattern extends Subtype[String]
    type EventPattern = zio.aws.eventbridge.model.primitives.EventPattern.Type
    object EventResource extends Subtype[String]
    type EventResource = zio.aws.eventbridge.model.primitives.EventResource.Type
    object EventSourceName extends Subtype[String]
    type EventSourceName =
      zio.aws.eventbridge.model.primitives.EventSourceName.Type
    object EventSourceNamePrefix extends Subtype[String]
    type EventSourceNamePrefix =
      zio.aws.eventbridge.model.primitives.EventSourceNamePrefix.Type
    object EventTime extends Subtype[Instant]
    type EventTime = zio.aws.eventbridge.model.primitives.EventTime.Type
    object HeaderKey extends Subtype[String]
    type HeaderKey = zio.aws.eventbridge.model.primitives.HeaderKey.Type
    object HeaderValue extends Subtype[String]
    type HeaderValue = zio.aws.eventbridge.model.primitives.HeaderValue.Type
    object HealthCheck extends Subtype[String]
    type HealthCheck = zio.aws.eventbridge.model.primitives.HealthCheck.Type
    object HomeRegion extends Subtype[String]
    type HomeRegion = zio.aws.eventbridge.model.primitives.HomeRegion.Type
    object HttpsEndpoint extends Subtype[String]
    type HttpsEndpoint = zio.aws.eventbridge.model.primitives.HttpsEndpoint.Type
    object IamRoleArn extends Subtype[String]
    type IamRoleArn = zio.aws.eventbridge.model.primitives.IamRoleArn.Type
    object InputTransformerPathKey extends Subtype[String]
    type InputTransformerPathKey =
      zio.aws.eventbridge.model.primitives.InputTransformerPathKey.Type
    type Integer = Int
    object LimitMax100 extends Subtype[Int]
    type LimitMax100 = zio.aws.eventbridge.model.primitives.LimitMax100.Type
    object LimitMin1 extends Subtype[Int]
    type LimitMin1 = zio.aws.eventbridge.model.primitives.LimitMin1.Type
    object ManagedBy extends Subtype[String]
    type ManagedBy = zio.aws.eventbridge.model.primitives.ManagedBy.Type
    object MaximumEventAgeInSeconds extends Subtype[Int]
    type MaximumEventAgeInSeconds =
      zio.aws.eventbridge.model.primitives.MaximumEventAgeInSeconds.Type
    object MaximumRetryAttempts extends Subtype[Int]
    type MaximumRetryAttempts =
      zio.aws.eventbridge.model.primitives.MaximumRetryAttempts.Type
    object MessageGroupId extends Subtype[String]
    type MessageGroupId =
      zio.aws.eventbridge.model.primitives.MessageGroupId.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.eventbridge.model.primitives.NextToken.Type
    object NonPartnerEventBusArn extends Subtype[String]
    type NonPartnerEventBusArn =
      zio.aws.eventbridge.model.primitives.NonPartnerEventBusArn.Type
    object NonPartnerEventBusName extends Subtype[String]
    type NonPartnerEventBusName =
      zio.aws.eventbridge.model.primitives.NonPartnerEventBusName.Type
    object NonPartnerEventBusNameOrArn extends Subtype[String]
    type NonPartnerEventBusNameOrArn =
      zio.aws.eventbridge.model.primitives.NonPartnerEventBusNameOrArn.Type
    object PartnerEventSourceNamePrefix extends Subtype[String]
    type PartnerEventSourceNamePrefix =
      zio.aws.eventbridge.model.primitives.PartnerEventSourceNamePrefix.Type
    object PathParameter extends Subtype[String]
    type PathParameter = zio.aws.eventbridge.model.primitives.PathParameter.Type
    object PlacementConstraintExpression extends Subtype[String]
    type PlacementConstraintExpression =
      zio.aws.eventbridge.model.primitives.PlacementConstraintExpression.Type
    object PlacementStrategyField extends Subtype[String]
    type PlacementStrategyField =
      zio.aws.eventbridge.model.primitives.PlacementStrategyField.Type
    object Principal extends Subtype[String]
    type Principal = zio.aws.eventbridge.model.primitives.Principal.Type
    object QueryStringKey extends Subtype[String]
    type QueryStringKey =
      zio.aws.eventbridge.model.primitives.QueryStringKey.Type
    object QueryStringValue extends Subtype[String]
    type QueryStringValue =
      zio.aws.eventbridge.model.primitives.QueryStringValue.Type
    object RedshiftSecretManagerArn extends Subtype[String]
    type RedshiftSecretManagerArn =
      zio.aws.eventbridge.model.primitives.RedshiftSecretManagerArn.Type
    object ReferenceId extends Subtype[String]
    type ReferenceId = zio.aws.eventbridge.model.primitives.ReferenceId.Type
    object ReplayArn extends Subtype[String]
    type ReplayArn = zio.aws.eventbridge.model.primitives.ReplayArn.Type
    object ReplayDescription extends Subtype[String]
    type ReplayDescription =
      zio.aws.eventbridge.model.primitives.ReplayDescription.Type
    object ReplayName extends Subtype[String]
    type ReplayName = zio.aws.eventbridge.model.primitives.ReplayName.Type
    object ReplayStateReason extends Subtype[String]
    type ReplayStateReason =
      zio.aws.eventbridge.model.primitives.ReplayStateReason.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.eventbridge.model.primitives.ResourceArn.Type
    object RetentionDays extends Subtype[Int]
    type RetentionDays = zio.aws.eventbridge.model.primitives.RetentionDays.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.eventbridge.model.primitives.RoleArn.Type
    object Route extends Subtype[String]
    type Route = zio.aws.eventbridge.model.primitives.Route.Type
    object RuleArn extends Subtype[String]
    type RuleArn = zio.aws.eventbridge.model.primitives.RuleArn.Type
    object RuleDescription extends Subtype[String]
    type RuleDescription =
      zio.aws.eventbridge.model.primitives.RuleDescription.Type
    object RuleName extends Subtype[String]
    type RuleName = zio.aws.eventbridge.model.primitives.RuleName.Type
    object RunCommandTargetKey extends Subtype[String]
    type RunCommandTargetKey =
      zio.aws.eventbridge.model.primitives.RunCommandTargetKey.Type
    object RunCommandTargetValue extends Subtype[String]
    type RunCommandTargetValue =
      zio.aws.eventbridge.model.primitives.RunCommandTargetValue.Type
    object SageMakerPipelineParameterName extends Subtype[String]
    type SageMakerPipelineParameterName =
      zio.aws.eventbridge.model.primitives.SageMakerPipelineParameterName.Type
    object SageMakerPipelineParameterValue extends Subtype[String]
    type SageMakerPipelineParameterValue =
      zio.aws.eventbridge.model.primitives.SageMakerPipelineParameterValue.Type
    object ScheduleExpression extends Subtype[String]
    type ScheduleExpression =
      zio.aws.eventbridge.model.primitives.ScheduleExpression.Type
    object SecretsManagerSecretArn extends Subtype[String]
    type SecretsManagerSecretArn =
      zio.aws.eventbridge.model.primitives.SecretsManagerSecretArn.Type
    object Sql extends Subtype[String]
    type Sql = zio.aws.eventbridge.model.primitives.Sql.Type
    object StatementId extends Subtype[String]
    type StatementId = zio.aws.eventbridge.model.primitives.StatementId.Type
    object StatementName extends Subtype[String]
    type StatementName = zio.aws.eventbridge.model.primitives.StatementName.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.eventbridge.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.eventbridge.model.primitives.TagValue.Type
    object TargetArn extends Subtype[String]
    type TargetArn = zio.aws.eventbridge.model.primitives.TargetArn.Type
    object TargetId extends Subtype[String]
    type TargetId = zio.aws.eventbridge.model.primitives.TargetId.Type
    object TargetInput extends Subtype[String]
    type TargetInput = zio.aws.eventbridge.model.primitives.TargetInput.Type
    object TargetInputPath extends Subtype[String]
    type TargetInputPath =
      zio.aws.eventbridge.model.primitives.TargetInputPath.Type
    object TargetPartitionKeyPath extends Subtype[String]
    type TargetPartitionKeyPath =
      zio.aws.eventbridge.model.primitives.TargetPartitionKeyPath.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.eventbridge.model.primitives.Timestamp.Type
    object TraceHeader extends Subtype[String]
    type TraceHeader = zio.aws.eventbridge.model.primitives.TraceHeader.Type
    object TransformerInput extends Subtype[String]
    type TransformerInput =
      zio.aws.eventbridge.model.primitives.TransformerInput.Type
  }
  type ApiDestinationResponseList =
    List[zio.aws.eventbridge.model.ApiDestination]
  type ArchiveResponseList = List[zio.aws.eventbridge.model.Archive]
  type CapacityProviderStrategy =
    List[zio.aws.eventbridge.model.CapacityProviderStrategyItem]
  type ConnectionBodyParametersList =
    List[zio.aws.eventbridge.model.ConnectionBodyParameter]
  type ConnectionHeaderParametersList =
    List[zio.aws.eventbridge.model.ConnectionHeaderParameter]
  type ConnectionQueryStringParametersList =
    List[zio.aws.eventbridge.model.ConnectionQueryStringParameter]
  type ConnectionResponseList = List[zio.aws.eventbridge.model.Connection]
  type EndpointEventBusList = List[zio.aws.eventbridge.model.EndpointEventBus]
  type EndpointList = List[zio.aws.eventbridge.model.Endpoint]
  type EventBusList = List[zio.aws.eventbridge.model.EventBus]
  type EventResourceList = List[EventResource]
  type EventSourceList = List[zio.aws.eventbridge.model.EventSource]
  type HeaderParametersMap = Map[HeaderKey, HeaderValue]
  type PartnerEventSourceAccountList =
    List[zio.aws.eventbridge.model.PartnerEventSourceAccount]
  type PartnerEventSourceList =
    List[zio.aws.eventbridge.model.PartnerEventSource]
  type PathParameterList = List[PathParameter]
  type PlacementConstraints =
    List[zio.aws.eventbridge.model.PlacementConstraint]
  type PlacementStrategies = List[zio.aws.eventbridge.model.PlacementStrategy]
  type PutEventsRequestEntryList =
    List[zio.aws.eventbridge.model.PutEventsRequestEntry]
  type PutEventsResultEntryList =
    List[zio.aws.eventbridge.model.PutEventsResultEntry]
  type PutPartnerEventsRequestEntryList =
    List[zio.aws.eventbridge.model.PutPartnerEventsRequestEntry]
  type PutPartnerEventsResultEntryList =
    List[zio.aws.eventbridge.model.PutPartnerEventsResultEntry]
  type PutTargetsResultEntryList =
    List[zio.aws.eventbridge.model.PutTargetsResultEntry]
  type QueryStringParametersMap = Map[QueryStringKey, QueryStringValue]
  type RemoveTargetsResultEntryList =
    List[zio.aws.eventbridge.model.RemoveTargetsResultEntry]
  type ReplayDestinationFilters = List[Arn]
  type ReplayList = List[zio.aws.eventbridge.model.Replay]
  type RuleNameList = List[RuleName]
  type RuleResponseList = List[zio.aws.eventbridge.model.Rule]
  type RunCommandTargetValues = List[RunCommandTargetValue]
  type RunCommandTargets = List[zio.aws.eventbridge.model.RunCommandTarget]
  type SageMakerPipelineParameterList =
    List[zio.aws.eventbridge.model.SageMakerPipelineParameter]
  type StringList = List[String]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.eventbridge.model.Tag]
  type TargetIdList = List[TargetId]
  type TargetList = List[zio.aws.eventbridge.model.Target]
  type TransformerPaths = Map[InputTransformerPathKey, TargetInputPath]
}
