package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{
  IamRoleArn,
  EndpointDescription,
  EndpointName
}
import scala.jdk.CollectionConverters._
final case class UpdateEndpointRequest(
    name: EndpointName,
    description: Optional[EndpointDescription] = Optional.Absent,
    routingConfig: Optional[zio.aws.eventbridge.model.RoutingConfig] =
      Optional.Absent,
    replicationConfig: Optional[zio.aws.eventbridge.model.ReplicationConfig] =
      Optional.Absent,
    eventBuses: Optional[Iterable[zio.aws.eventbridge.model.EndpointEventBus]] =
      Optional.Absent,
    roleArn: Optional[IamRoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.UpdateEndpointRequest = {
    import UpdateEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.UpdateEndpointRequest
      .builder()
      .name(EndpointName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          EndpointDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(routingConfig.map(value => value.buildAwsValue()))(
        _.routingConfig
      )
      .optionallyWith(replicationConfig.map(value => value.buildAwsValue()))(
        _.replicationConfig
      )
      .optionallyWith(
        eventBuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventBuses)
      .optionallyWith(
        roleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.UpdateEndpointRequest.ReadOnly =
    zio.aws.eventbridge.model.UpdateEndpointRequest.wrap(buildAwsValue())
}
object UpdateEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.UpdateEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.UpdateEndpointRequest =
      zio.aws.eventbridge.model.UpdateEndpointRequest(
        name,
        description.map(value => value),
        routingConfig.map(value => value.asEditable),
        replicationConfig.map(value => value.asEditable),
        eventBuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        roleArn.map(value => value)
      )
    def name: EndpointName
    def description: Optional[EndpointDescription]
    def routingConfig
        : Optional[zio.aws.eventbridge.model.RoutingConfig.ReadOnly]
    def replicationConfig
        : Optional[zio.aws.eventbridge.model.ReplicationConfig.ReadOnly]
    def eventBuses
        : Optional[List[zio.aws.eventbridge.model.EndpointEventBus.ReadOnly]]
    def roleArn: Optional[IamRoleArn]
    def getName: ZIO[Any, Nothing, EndpointName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, EndpointDescription] =
      AwsError.unwrapOptionField("description", description)
    def getRoutingConfig
        : ZIO[Any, AwsError, zio.aws.eventbridge.model.RoutingConfig.ReadOnly] =
      AwsError.unwrapOptionField("routingConfig", routingConfig)
    def getReplicationConfig: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.ReplicationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("replicationConfig", replicationConfig)
    def getEventBuses: ZIO[Any, AwsError, List[
      zio.aws.eventbridge.model.EndpointEventBus.ReadOnly
    ]] = AwsError.unwrapOptionField("eventBuses", eventBuses)
    def getRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.UpdateEndpointRequest
  ) extends zio.aws.eventbridge.model.UpdateEndpointRequest.ReadOnly {
    override val name: EndpointName =
      zio.aws.eventbridge.model.primitives.EndpointName(impl.name())
    override val description: Optional[EndpointDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.eventbridge.model.primitives.EndpointDescription(value)
        )
    override val routingConfig
        : Optional[zio.aws.eventbridge.model.RoutingConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routingConfig())
        .map(value => zio.aws.eventbridge.model.RoutingConfig.wrap(value))
    override val replicationConfig
        : Optional[zio.aws.eventbridge.model.ReplicationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationConfig())
        .map(value => zio.aws.eventbridge.model.ReplicationConfig.wrap(value))
    override val eventBuses
        : Optional[List[zio.aws.eventbridge.model.EndpointEventBus.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventBuses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eventbridge.model.EndpointEventBus.wrap(item)
          }.toList
        )
    override val roleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.eventbridge.model.primitives.IamRoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.UpdateEndpointRequest
  ): zio.aws.eventbridge.model.UpdateEndpointRequest.ReadOnly = new Wrapper(
    impl
  )
}
