package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{
  ConnectionDescription,
  ConnectionName
}
import scala.jdk.CollectionConverters._
final case class UpdateConnectionRequest(
    name: ConnectionName,
    description: Optional[ConnectionDescription] = Optional.Absent,
    authorizationType: Optional[
      zio.aws.eventbridge.model.ConnectionAuthorizationType
    ] = Optional.Absent,
    authParameters: Optional[
      zio.aws.eventbridge.model.UpdateConnectionAuthRequestParameters
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.UpdateConnectionRequest = {
    import UpdateConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.UpdateConnectionRequest
      .builder()
      .name(ConnectionName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ConnectionDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(authorizationType.map(value => value.unwrap))(
        _.authorizationType
      )
      .optionallyWith(authParameters.map(value => value.buildAwsValue()))(
        _.authParameters
      )
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.UpdateConnectionRequest.ReadOnly =
    zio.aws.eventbridge.model.UpdateConnectionRequest.wrap(buildAwsValue())
}
object UpdateConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.UpdateConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.UpdateConnectionRequest =
      zio.aws.eventbridge.model.UpdateConnectionRequest(
        name,
        description.map(value => value),
        authorizationType.map(value => value),
        authParameters.map(value => value.asEditable)
      )
    def name: ConnectionName
    def description: Optional[ConnectionDescription]
    def authorizationType
        : Optional[zio.aws.eventbridge.model.ConnectionAuthorizationType]
    def authParameters: Optional[
      zio.aws.eventbridge.model.UpdateConnectionAuthRequestParameters.ReadOnly
    ]
    def getName: ZIO[Any, Nothing, ConnectionName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, ConnectionDescription] =
      AwsError.unwrapOptionField("description", description)
    def getAuthorizationType: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.ConnectionAuthorizationType
    ] = AwsError.unwrapOptionField("authorizationType", authorizationType)
    def getAuthParameters: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.UpdateConnectionAuthRequestParameters.ReadOnly
    ] = AwsError.unwrapOptionField("authParameters", authParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.UpdateConnectionRequest
  ) extends zio.aws.eventbridge.model.UpdateConnectionRequest.ReadOnly {
    override val name: ConnectionName =
      zio.aws.eventbridge.model.primitives.ConnectionName(impl.name())
    override val description: Optional[ConnectionDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.eventbridge.model.primitives.ConnectionDescription(value)
        )
    override val authorizationType
        : Optional[zio.aws.eventbridge.model.ConnectionAuthorizationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorizationType())
        .map(value =>
          zio.aws.eventbridge.model.ConnectionAuthorizationType.wrap(value)
        )
    override val authParameters: Optional[
      zio.aws.eventbridge.model.UpdateConnectionAuthRequestParameters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.authParameters())
      .map(value =>
        zio.aws.eventbridge.model.UpdateConnectionAuthRequestParameters
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.UpdateConnectionRequest
  ): zio.aws.eventbridge.model.UpdateConnectionRequest.ReadOnly = new Wrapper(
    impl
  )
}
