package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.HttpsEndpoint
import scala.jdk.CollectionConverters._
final case class UpdateConnectionOAuthRequestParameters(
    clientParameters: Optional[
      zio.aws.eventbridge.model.UpdateConnectionOAuthClientRequestParameters
    ] = Optional.Absent,
    authorizationEndpoint: Optional[HttpsEndpoint] = Optional.Absent,
    httpMethod: Optional[zio.aws.eventbridge.model.ConnectionOAuthHttpMethod] =
      Optional.Absent,
    oAuthHttpParameters: Optional[
      zio.aws.eventbridge.model.ConnectionHttpParameters
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.UpdateConnectionOAuthRequestParameters = {
    import UpdateConnectionOAuthRequestParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.UpdateConnectionOAuthRequestParameters
      .builder()
      .optionallyWith(clientParameters.map(value => value.buildAwsValue()))(
        _.clientParameters
      )
      .optionallyWith(
        authorizationEndpoint.map(value =>
          HttpsEndpoint.unwrap(value): java.lang.String
        )
      )(_.authorizationEndpoint)
      .optionallyWith(httpMethod.map(value => value.unwrap))(_.httpMethod)
      .optionallyWith(oAuthHttpParameters.map(value => value.buildAwsValue()))(
        _.oAuthHttpParameters
      )
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.UpdateConnectionOAuthRequestParameters.ReadOnly =
    zio.aws.eventbridge.model.UpdateConnectionOAuthRequestParameters
      .wrap(buildAwsValue())
}
object UpdateConnectionOAuthRequestParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.UpdateConnectionOAuthRequestParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.eventbridge.model.UpdateConnectionOAuthRequestParameters =
      zio.aws.eventbridge.model.UpdateConnectionOAuthRequestParameters(
        clientParameters.map(value => value.asEditable),
        authorizationEndpoint.map(value => value),
        httpMethod.map(value => value),
        oAuthHttpParameters.map(value => value.asEditable)
      )
    def clientParameters: Optional[
      zio.aws.eventbridge.model.UpdateConnectionOAuthClientRequestParameters.ReadOnly
    ]
    def authorizationEndpoint: Optional[HttpsEndpoint]
    def httpMethod
        : Optional[zio.aws.eventbridge.model.ConnectionOAuthHttpMethod]
    def oAuthHttpParameters
        : Optional[zio.aws.eventbridge.model.ConnectionHttpParameters.ReadOnly]
    def getClientParameters: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.UpdateConnectionOAuthClientRequestParameters.ReadOnly
    ] = AwsError.unwrapOptionField("clientParameters", clientParameters)
    def getAuthorizationEndpoint: ZIO[Any, AwsError, HttpsEndpoint] =
      AwsError.unwrapOptionField("authorizationEndpoint", authorizationEndpoint)
    def getHttpMethod: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.ConnectionOAuthHttpMethod
    ] = AwsError.unwrapOptionField("httpMethod", httpMethod)
    def getOAuthHttpParameters: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.ConnectionHttpParameters.ReadOnly
    ] = AwsError.unwrapOptionField("oAuthHttpParameters", oAuthHttpParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.UpdateConnectionOAuthRequestParameters
  ) extends zio.aws.eventbridge.model.UpdateConnectionOAuthRequestParameters.ReadOnly {
    override val clientParameters: Optional[
      zio.aws.eventbridge.model.UpdateConnectionOAuthClientRequestParameters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.clientParameters())
      .map(value =>
        zio.aws.eventbridge.model.UpdateConnectionOAuthClientRequestParameters
          .wrap(value)
      )
    override val authorizationEndpoint: Optional[HttpsEndpoint] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorizationEndpoint())
        .map(value => zio.aws.eventbridge.model.primitives.HttpsEndpoint(value))
    override val httpMethod
        : Optional[zio.aws.eventbridge.model.ConnectionOAuthHttpMethod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpMethod())
        .map(value =>
          zio.aws.eventbridge.model.ConnectionOAuthHttpMethod.wrap(value)
        )
    override val oAuthHttpParameters: Optional[
      zio.aws.eventbridge.model.ConnectionHttpParameters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.oAuthHttpParameters())
      .map(value =>
        zio.aws.eventbridge.model.ConnectionHttpParameters.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.UpdateConnectionOAuthRequestParameters
  ): zio.aws.eventbridge.model.UpdateConnectionOAuthRequestParameters.ReadOnly =
    new Wrapper(impl)
}
