package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.AuthHeaderParameters
import scala.jdk.CollectionConverters._
final case class UpdateConnectionBasicAuthRequestParameters(
    username: Optional[AuthHeaderParameters] = Optional.Absent,
    password: Optional[AuthHeaderParameters] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.UpdateConnectionBasicAuthRequestParameters = {
    import UpdateConnectionBasicAuthRequestParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.UpdateConnectionBasicAuthRequestParameters
      .builder()
      .optionallyWith(
        username.map(value =>
          AuthHeaderParameters.unwrap(value): java.lang.String
        )
      )(_.username)
      .optionallyWith(
        password.map(value =>
          AuthHeaderParameters.unwrap(value): java.lang.String
        )
      )(_.password)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.UpdateConnectionBasicAuthRequestParameters.ReadOnly =
    zio.aws.eventbridge.model.UpdateConnectionBasicAuthRequestParameters
      .wrap(buildAwsValue())
}
object UpdateConnectionBasicAuthRequestParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.UpdateConnectionBasicAuthRequestParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.eventbridge.model.UpdateConnectionBasicAuthRequestParameters =
      zio.aws.eventbridge.model.UpdateConnectionBasicAuthRequestParameters(
        username.map(value => value),
        password.map(value => value)
      )
    def username: Optional[AuthHeaderParameters]
    def password: Optional[AuthHeaderParameters]
    def getUsername: ZIO[Any, AwsError, AuthHeaderParameters] =
      AwsError.unwrapOptionField("username", username)
    def getPassword: ZIO[Any, AwsError, AuthHeaderParameters] =
      AwsError.unwrapOptionField("password", password)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.UpdateConnectionBasicAuthRequestParameters
  ) extends zio.aws.eventbridge.model.UpdateConnectionBasicAuthRequestParameters.ReadOnly {
    override val username: Optional[AuthHeaderParameters] =
      zio.aws.core.internal
        .optionalFromNullable(impl.username())
        .map(value =>
          zio.aws.eventbridge.model.primitives.AuthHeaderParameters(value)
        )
    override val password: Optional[AuthHeaderParameters] =
      zio.aws.core.internal
        .optionalFromNullable(impl.password())
        .map(value =>
          zio.aws.eventbridge.model.primitives.AuthHeaderParameters(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.UpdateConnectionBasicAuthRequestParameters
  ): zio.aws.eventbridge.model.UpdateConnectionBasicAuthRequestParameters.ReadOnly =
    new Wrapper(impl)
}
