package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateConnectionAuthRequestParameters(
    basicAuthParameters: Optional[
      zio.aws.eventbridge.model.UpdateConnectionBasicAuthRequestParameters
    ] = Optional.Absent,
    oAuthParameters: Optional[
      zio.aws.eventbridge.model.UpdateConnectionOAuthRequestParameters
    ] = Optional.Absent,
    apiKeyAuthParameters: Optional[
      zio.aws.eventbridge.model.UpdateConnectionApiKeyAuthRequestParameters
    ] = Optional.Absent,
    invocationHttpParameters: Optional[
      zio.aws.eventbridge.model.ConnectionHttpParameters
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.UpdateConnectionAuthRequestParameters = {
    import UpdateConnectionAuthRequestParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.UpdateConnectionAuthRequestParameters
      .builder()
      .optionallyWith(basicAuthParameters.map(value => value.buildAwsValue()))(
        _.basicAuthParameters
      )
      .optionallyWith(oAuthParameters.map(value => value.buildAwsValue()))(
        _.oAuthParameters
      )
      .optionallyWith(apiKeyAuthParameters.map(value => value.buildAwsValue()))(
        _.apiKeyAuthParameters
      )
      .optionallyWith(
        invocationHttpParameters.map(value => value.buildAwsValue())
      )(_.invocationHttpParameters)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.UpdateConnectionAuthRequestParameters.ReadOnly =
    zio.aws.eventbridge.model.UpdateConnectionAuthRequestParameters
      .wrap(buildAwsValue())
}
object UpdateConnectionAuthRequestParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.UpdateConnectionAuthRequestParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.eventbridge.model.UpdateConnectionAuthRequestParameters =
      zio.aws.eventbridge.model.UpdateConnectionAuthRequestParameters(
        basicAuthParameters.map(value => value.asEditable),
        oAuthParameters.map(value => value.asEditable),
        apiKeyAuthParameters.map(value => value.asEditable),
        invocationHttpParameters.map(value => value.asEditable)
      )
    def basicAuthParameters: Optional[
      zio.aws.eventbridge.model.UpdateConnectionBasicAuthRequestParameters.ReadOnly
    ]
    def oAuthParameters: Optional[
      zio.aws.eventbridge.model.UpdateConnectionOAuthRequestParameters.ReadOnly
    ]
    def apiKeyAuthParameters: Optional[
      zio.aws.eventbridge.model.UpdateConnectionApiKeyAuthRequestParameters.ReadOnly
    ]
    def invocationHttpParameters
        : Optional[zio.aws.eventbridge.model.ConnectionHttpParameters.ReadOnly]
    def getBasicAuthParameters: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.UpdateConnectionBasicAuthRequestParameters.ReadOnly
    ] = AwsError.unwrapOptionField("basicAuthParameters", basicAuthParameters)
    def getOAuthParameters: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.UpdateConnectionOAuthRequestParameters.ReadOnly
    ] = AwsError.unwrapOptionField("oAuthParameters", oAuthParameters)
    def getApiKeyAuthParameters: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.UpdateConnectionApiKeyAuthRequestParameters.ReadOnly
    ] = AwsError.unwrapOptionField("apiKeyAuthParameters", apiKeyAuthParameters)
    def getInvocationHttpParameters: ZIO[
      Any,
      AwsError,
      zio.aws.eventbridge.model.ConnectionHttpParameters.ReadOnly
    ] = AwsError.unwrapOptionField(
      "invocationHttpParameters",
      invocationHttpParameters
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.UpdateConnectionAuthRequestParameters
  ) extends zio.aws.eventbridge.model.UpdateConnectionAuthRequestParameters.ReadOnly {
    override val basicAuthParameters: Optional[
      zio.aws.eventbridge.model.UpdateConnectionBasicAuthRequestParameters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.basicAuthParameters())
      .map(value =>
        zio.aws.eventbridge.model.UpdateConnectionBasicAuthRequestParameters
          .wrap(value)
      )
    override val oAuthParameters: Optional[
      zio.aws.eventbridge.model.UpdateConnectionOAuthRequestParameters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.oAuthParameters())
      .map(value =>
        zio.aws.eventbridge.model.UpdateConnectionOAuthRequestParameters
          .wrap(value)
      )
    override val apiKeyAuthParameters: Optional[
      zio.aws.eventbridge.model.UpdateConnectionApiKeyAuthRequestParameters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.apiKeyAuthParameters())
      .map(value =>
        zio.aws.eventbridge.model.UpdateConnectionApiKeyAuthRequestParameters
          .wrap(value)
      )
    override val invocationHttpParameters: Optional[
      zio.aws.eventbridge.model.ConnectionHttpParameters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.invocationHttpParameters())
      .map(value =>
        zio.aws.eventbridge.model.ConnectionHttpParameters.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.UpdateConnectionAuthRequestParameters
  ): zio.aws.eventbridge.model.UpdateConnectionAuthRequestParameters.ReadOnly =
    new Wrapper(impl)
}
