package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  RetentionDays,
  EventPattern,
  ArchiveDescription,
  ArchiveName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateArchiveRequest(
    archiveName: ArchiveName,
    description: Optional[ArchiveDescription] = Optional.Absent,
    eventPattern: Optional[EventPattern] = Optional.Absent,
    retentionDays: Optional[RetentionDays] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.UpdateArchiveRequest = {
    import UpdateArchiveRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.UpdateArchiveRequest
      .builder()
      .archiveName(ArchiveName.unwrap(archiveName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ArchiveDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        eventPattern.map(value => EventPattern.unwrap(value): java.lang.String)
      )(_.eventPattern)
      .optionallyWith(
        retentionDays.map(value => RetentionDays.unwrap(value): Integer)
      )(_.retentionDays)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.UpdateArchiveRequest.ReadOnly =
    zio.aws.eventbridge.model.UpdateArchiveRequest.wrap(buildAwsValue())
}
object UpdateArchiveRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.UpdateArchiveRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.UpdateArchiveRequest =
      zio.aws.eventbridge.model.UpdateArchiveRequest(
        archiveName,
        description.map(value => value),
        eventPattern.map(value => value),
        retentionDays.map(value => value)
      )
    def archiveName: ArchiveName
    def description: Optional[ArchiveDescription]
    def eventPattern: Optional[EventPattern]
    def retentionDays: Optional[RetentionDays]
    def getArchiveName: ZIO[Any, Nothing, ArchiveName] =
      ZIO.succeed(archiveName)
    def getDescription: ZIO[Any, AwsError, ArchiveDescription] =
      AwsError.unwrapOptionField("description", description)
    def getEventPattern: ZIO[Any, AwsError, EventPattern] =
      AwsError.unwrapOptionField("eventPattern", eventPattern)
    def getRetentionDays: ZIO[Any, AwsError, RetentionDays] =
      AwsError.unwrapOptionField("retentionDays", retentionDays)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.UpdateArchiveRequest
  ) extends zio.aws.eventbridge.model.UpdateArchiveRequest.ReadOnly {
    override val archiveName: ArchiveName =
      zio.aws.eventbridge.model.primitives.ArchiveName(impl.archiveName())
    override val description: Optional[ArchiveDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.eventbridge.model.primitives.ArchiveDescription(value)
        )
    override val eventPattern: Optional[EventPattern] = zio.aws.core.internal
      .optionalFromNullable(impl.eventPattern())
      .map(value => zio.aws.eventbridge.model.primitives.EventPattern(value))
    override val retentionDays: Optional[RetentionDays] = zio.aws.core.internal
      .optionalFromNullable(impl.retentionDays())
      .map(value => zio.aws.eventbridge.model.primitives.RetentionDays(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.UpdateArchiveRequest
  ): zio.aws.eventbridge.model.UpdateArchiveRequest.ReadOnly = new Wrapper(impl)
}
