package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TestEventPatternResponse(
    result: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.TestEventPatternResponse = {
    import TestEventPatternResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.TestEventPatternResponse
      .builder()
      .optionallyWith(result.map(value => value: java.lang.Boolean))(_.result)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.TestEventPatternResponse.ReadOnly =
    zio.aws.eventbridge.model.TestEventPatternResponse.wrap(buildAwsValue())
}
object TestEventPatternResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.TestEventPatternResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.TestEventPatternResponse =
      zio.aws.eventbridge.model
        .TestEventPatternResponse(result.map(value => value))
    def result: Optional[Boolean]
    def getResult: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("result", result)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.TestEventPatternResponse
  ) extends zio.aws.eventbridge.model.TestEventPatternResponse.ReadOnly {
    override val result: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.result())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.TestEventPatternResponse
  ): zio.aws.eventbridge.model.TestEventPatternResponse.ReadOnly = new Wrapper(
    impl
  )
}
