package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceARN: Arn,
    tags: Iterable[zio.aws.eventbridge.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.TagResourceRequest
      .builder()
      .resourceARN(Arn.unwrap(resourceARN): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.TagResourceRequest.ReadOnly =
    zio.aws.eventbridge.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.TagResourceRequest =
      zio.aws.eventbridge.model.TagResourceRequest(
        resourceARN,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceARN: Arn
    def tags: List[zio.aws.eventbridge.model.Tag.ReadOnly]
    def getResourceARN: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceARN)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.eventbridge.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.TagResourceRequest
  ) extends zio.aws.eventbridge.model.TagResourceRequest.ReadOnly {
    override val resourceARN: Arn =
      zio.aws.eventbridge.model.primitives.Arn(impl.resourceARN())
    override val tags: List[zio.aws.eventbridge.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.eventbridge.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.TagResourceRequest
  ): zio.aws.eventbridge.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
