package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters._
final case class Tag(key: TagKey, value: TagValue) {
  def buildAwsValue(): software.amazon.awssdk.services.eventbridge.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.Tag
      .builder()
      .key(TagKey.unwrap(key): java.lang.String)
      .value(TagValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.Tag.ReadOnly =
    zio.aws.eventbridge.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.eventbridge.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.Tag =
      zio.aws.eventbridge.model.Tag(key, value)
    def key: TagKey
    def value: TagValue
    def getKey: ZIO[Any, Nothing, TagKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, TagValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.Tag
  ) extends zio.aws.eventbridge.model.Tag.ReadOnly {
    override val key: TagKey =
      zio.aws.eventbridge.model.primitives.TagKey(impl.key())
    override val value: TagValue =
      zio.aws.eventbridge.model.primitives.TagValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.Tag
  ): zio.aws.eventbridge.model.Tag.ReadOnly = new Wrapper(impl)
}
