package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  Timestamp,
  ReplayStateReason,
  ReplayArn
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class StartReplayResponse(
    replayArn: Optional[ReplayArn] = Optional.Absent,
    state: Optional[zio.aws.eventbridge.model.ReplayState] = Optional.Absent,
    stateReason: Optional[ReplayStateReason] = Optional.Absent,
    replayStartTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.StartReplayResponse = {
    import StartReplayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.StartReplayResponse
      .builder()
      .optionallyWith(
        replayArn.map(value => ReplayArn.unwrap(value): java.lang.String)
      )(_.replayArn)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        stateReason.map(value =>
          ReplayStateReason.unwrap(value): java.lang.String
        )
      )(_.stateReason)
      .optionallyWith(
        replayStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.replayStartTime)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.StartReplayResponse.ReadOnly =
    zio.aws.eventbridge.model.StartReplayResponse.wrap(buildAwsValue())
}
object StartReplayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.StartReplayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.StartReplayResponse =
      zio.aws.eventbridge.model.StartReplayResponse(
        replayArn.map(value => value),
        state.map(value => value),
        stateReason.map(value => value),
        replayStartTime.map(value => value)
      )
    def replayArn: Optional[ReplayArn]
    def state: Optional[zio.aws.eventbridge.model.ReplayState]
    def stateReason: Optional[ReplayStateReason]
    def replayStartTime: Optional[Timestamp]
    def getReplayArn: ZIO[Any, AwsError, ReplayArn] =
      AwsError.unwrapOptionField("replayArn", replayArn)
    def getState: ZIO[Any, AwsError, zio.aws.eventbridge.model.ReplayState] =
      AwsError.unwrapOptionField("state", state)
    def getStateReason: ZIO[Any, AwsError, ReplayStateReason] =
      AwsError.unwrapOptionField("stateReason", stateReason)
    def getReplayStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("replayStartTime", replayStartTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.StartReplayResponse
  ) extends zio.aws.eventbridge.model.StartReplayResponse.ReadOnly {
    override val replayArn: Optional[ReplayArn] = zio.aws.core.internal
      .optionalFromNullable(impl.replayArn())
      .map(value => zio.aws.eventbridge.model.primitives.ReplayArn(value))
    override val state: Optional[zio.aws.eventbridge.model.ReplayState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.eventbridge.model.ReplayState.wrap(value))
    override val stateReason: Optional[ReplayStateReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateReason())
        .map(value =>
          zio.aws.eventbridge.model.primitives.ReplayStateReason(value)
        )
    override val replayStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.replayStartTime())
      .map(value => zio.aws.eventbridge.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.StartReplayResponse
  ): zio.aws.eventbridge.model.StartReplayResponse.ReadOnly = new Wrapper(impl)
}
