package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  Timestamp,
  Arn,
  ReplayDescription,
  ReplayName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class StartReplayRequest(
    replayName: ReplayName,
    description: Optional[ReplayDescription] = Optional.Absent,
    eventSourceArn: Arn,
    eventStartTime: Timestamp,
    eventEndTime: Timestamp,
    destination: zio.aws.eventbridge.model.ReplayDestination
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.StartReplayRequest = {
    import StartReplayRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.StartReplayRequest
      .builder()
      .replayName(ReplayName.unwrap(replayName): java.lang.String)
      .optionallyWith(
        description.map(value =>
          ReplayDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .eventSourceArn(Arn.unwrap(eventSourceArn): java.lang.String)
      .eventStartTime(Timestamp.unwrap(eventStartTime): Instant)
      .eventEndTime(Timestamp.unwrap(eventEndTime): Instant)
      .destination(destination.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.StartReplayRequest.ReadOnly =
    zio.aws.eventbridge.model.StartReplayRequest.wrap(buildAwsValue())
}
object StartReplayRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.StartReplayRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.StartReplayRequest =
      zio.aws.eventbridge.model.StartReplayRequest(
        replayName,
        description.map(value => value),
        eventSourceArn,
        eventStartTime,
        eventEndTime,
        destination.asEditable
      )
    def replayName: ReplayName
    def description: Optional[ReplayDescription]
    def eventSourceArn: Arn
    def eventStartTime: Timestamp
    def eventEndTime: Timestamp
    def destination: zio.aws.eventbridge.model.ReplayDestination.ReadOnly
    def getReplayName: ZIO[Any, Nothing, ReplayName] = ZIO.succeed(replayName)
    def getDescription: ZIO[Any, AwsError, ReplayDescription] =
      AwsError.unwrapOptionField("description", description)
    def getEventSourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(eventSourceArn)
    def getEventStartTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(eventStartTime)
    def getEventEndTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(eventEndTime)
    def getDestination: ZIO[
      Any,
      Nothing,
      zio.aws.eventbridge.model.ReplayDestination.ReadOnly
    ] = ZIO.succeed(destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.StartReplayRequest
  ) extends zio.aws.eventbridge.model.StartReplayRequest.ReadOnly {
    override val replayName: ReplayName =
      zio.aws.eventbridge.model.primitives.ReplayName(impl.replayName())
    override val description: Optional[ReplayDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.eventbridge.model.primitives.ReplayDescription(value)
        )
    override val eventSourceArn: Arn =
      zio.aws.eventbridge.model.primitives.Arn(impl.eventSourceArn())
    override val eventStartTime: Timestamp =
      zio.aws.eventbridge.model.primitives.Timestamp(impl.eventStartTime())
    override val eventEndTime: Timestamp =
      zio.aws.eventbridge.model.primitives.Timestamp(impl.eventEndTime())
    override val destination
        : zio.aws.eventbridge.model.ReplayDestination.ReadOnly =
      zio.aws.eventbridge.model.ReplayDestination.wrap(impl.destination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.StartReplayRequest
  ): zio.aws.eventbridge.model.StartReplayRequest.ReadOnly = new Wrapper(impl)
}
