package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.Route
import scala.jdk.CollectionConverters._
final case class Secondary(route: Route) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.Secondary = {
    import Secondary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.Secondary
      .builder()
      .route(Route.unwrap(route): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.Secondary.ReadOnly =
    zio.aws.eventbridge.model.Secondary.wrap(buildAwsValue())
}
object Secondary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.Secondary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.Secondary =
      zio.aws.eventbridge.model.Secondary(route)
    def route: Route
    def getRoute: ZIO[Any, Nothing, Route] = ZIO.succeed(route)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.Secondary
  ) extends zio.aws.eventbridge.model.Secondary.ReadOnly {
    override val route: Route =
      zio.aws.eventbridge.model.primitives.Route(impl.route())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.Secondary
  ): zio.aws.eventbridge.model.Secondary.ReadOnly = new Wrapper(impl)
}
