package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.{
  SageMakerPipelineParameterValue,
  SageMakerPipelineParameterName
}
import scala.jdk.CollectionConverters._
final case class SageMakerPipelineParameter(
    name: SageMakerPipelineParameterName,
    value: SageMakerPipelineParameterValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.SageMakerPipelineParameter = {
    import SageMakerPipelineParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.SageMakerPipelineParameter
      .builder()
      .name(SageMakerPipelineParameterName.unwrap(name): java.lang.String)
      .value(SageMakerPipelineParameterValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.SageMakerPipelineParameter.ReadOnly =
    zio.aws.eventbridge.model.SageMakerPipelineParameter.wrap(buildAwsValue())
}
object SageMakerPipelineParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.SageMakerPipelineParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.SageMakerPipelineParameter =
      zio.aws.eventbridge.model.SageMakerPipelineParameter(name, value)
    def name: SageMakerPipelineParameterName
    def value: SageMakerPipelineParameterValue
    def getName: ZIO[Any, Nothing, SageMakerPipelineParameterName] =
      ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, SageMakerPipelineParameterValue] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.SageMakerPipelineParameter
  ) extends zio.aws.eventbridge.model.SageMakerPipelineParameter.ReadOnly {
    override val name: SageMakerPipelineParameterName =
      zio.aws.eventbridge.model.primitives
        .SageMakerPipelineParameterName(impl.name())
    override val value: SageMakerPipelineParameterValue =
      zio.aws.eventbridge.model.primitives
        .SageMakerPipelineParameterValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.SageMakerPipelineParameter
  ): zio.aws.eventbridge.model.SageMakerPipelineParameter.ReadOnly =
    new Wrapper(impl)
}
