package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.{
  RunCommandTargetValue,
  RunCommandTargetKey
}
import scala.jdk.CollectionConverters._
final case class RunCommandTarget(
    key: RunCommandTargetKey,
    values: Iterable[RunCommandTargetValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.RunCommandTarget = {
    import RunCommandTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.RunCommandTarget
      .builder()
      .key(RunCommandTargetKey.unwrap(key): java.lang.String)
      .values(values.map { item =>
        RunCommandTargetValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.RunCommandTarget.ReadOnly =
    zio.aws.eventbridge.model.RunCommandTarget.wrap(buildAwsValue())
}
object RunCommandTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.RunCommandTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.RunCommandTarget =
      zio.aws.eventbridge.model.RunCommandTarget(key, values)
    def key: RunCommandTargetKey
    def values: List[RunCommandTargetValue]
    def getKey: ZIO[Any, Nothing, RunCommandTargetKey] = ZIO.succeed(key)
    def getValues: ZIO[Any, Nothing, List[RunCommandTargetValue]] =
      ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.RunCommandTarget
  ) extends zio.aws.eventbridge.model.RunCommandTarget.ReadOnly {
    override val key: RunCommandTargetKey =
      zio.aws.eventbridge.model.primitives.RunCommandTargetKey(impl.key())
    override val values: List[RunCommandTargetValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.eventbridge.model.primitives.RunCommandTargetValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.RunCommandTarget
  ): zio.aws.eventbridge.model.RunCommandTarget.ReadOnly = new Wrapper(impl)
}
