package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RunCommandParameters(
    runCommandTargets: Iterable[zio.aws.eventbridge.model.RunCommandTarget]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.RunCommandParameters = {
    import RunCommandParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.RunCommandParameters
      .builder()
      .runCommandTargets(runCommandTargets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.RunCommandParameters.ReadOnly =
    zio.aws.eventbridge.model.RunCommandParameters.wrap(buildAwsValue())
}
object RunCommandParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.RunCommandParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.RunCommandParameters =
      zio.aws.eventbridge.model.RunCommandParameters(runCommandTargets.map {
        item =>
          item.asEditable
      })
    def runCommandTargets
        : List[zio.aws.eventbridge.model.RunCommandTarget.ReadOnly]
    def getRunCommandTargets: ZIO[Any, Nothing, List[
      zio.aws.eventbridge.model.RunCommandTarget.ReadOnly
    ]] = ZIO.succeed(runCommandTargets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.RunCommandParameters
  ) extends zio.aws.eventbridge.model.RunCommandParameters.ReadOnly {
    override val runCommandTargets
        : List[zio.aws.eventbridge.model.RunCommandTarget.ReadOnly] = impl
      .runCommandTargets()
      .asScala
      .map { item =>
        zio.aws.eventbridge.model.RunCommandTarget.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.RunCommandParameters
  ): zio.aws.eventbridge.model.RunCommandParameters.ReadOnly = new Wrapper(impl)
}
