package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  MaximumEventAgeInSeconds,
  MaximumRetryAttempts
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RetryPolicy(
    maximumRetryAttempts: Optional[MaximumRetryAttempts] = Optional.Absent,
    maximumEventAgeInSeconds: Optional[MaximumEventAgeInSeconds] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.RetryPolicy = {
    import RetryPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.RetryPolicy
      .builder()
      .optionallyWith(
        maximumRetryAttempts.map(value =>
          MaximumRetryAttempts.unwrap(value): Integer
        )
      )(_.maximumRetryAttempts)
      .optionallyWith(
        maximumEventAgeInSeconds.map(value =>
          MaximumEventAgeInSeconds.unwrap(value): Integer
        )
      )(_.maximumEventAgeInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.RetryPolicy.ReadOnly =
    zio.aws.eventbridge.model.RetryPolicy.wrap(buildAwsValue())
}
object RetryPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.RetryPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.RetryPolicy =
      zio.aws.eventbridge.model.RetryPolicy(
        maximumRetryAttempts.map(value => value),
        maximumEventAgeInSeconds.map(value => value)
      )
    def maximumRetryAttempts: Optional[MaximumRetryAttempts]
    def maximumEventAgeInSeconds: Optional[MaximumEventAgeInSeconds]
    def getMaximumRetryAttempts: ZIO[Any, AwsError, MaximumRetryAttempts] =
      AwsError.unwrapOptionField("maximumRetryAttempts", maximumRetryAttempts)
    def getMaximumEventAgeInSeconds
        : ZIO[Any, AwsError, MaximumEventAgeInSeconds] = AwsError
      .unwrapOptionField("maximumEventAgeInSeconds", maximumEventAgeInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.RetryPolicy
  ) extends zio.aws.eventbridge.model.RetryPolicy.ReadOnly {
    override val maximumRetryAttempts: Optional[MaximumRetryAttempts] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumRetryAttempts())
        .map(value =>
          zio.aws.eventbridge.model.primitives.MaximumRetryAttempts(value)
        )
    override val maximumEventAgeInSeconds: Optional[MaximumEventAgeInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumEventAgeInSeconds())
        .map(value =>
          zio.aws.eventbridge.model.primitives.MaximumEventAgeInSeconds(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.RetryPolicy
  ): zio.aws.eventbridge.model.RetryPolicy.ReadOnly = new Wrapper(impl)
}
