package zio.aws.eventbridge.model
import scala.jdk.CollectionConverters._
sealed trait ReplayState {
  def unwrap: software.amazon.awssdk.services.eventbridge.model.ReplayState
}
object ReplayState {
  def wrap(
      value: software.amazon.awssdk.services.eventbridge.model.ReplayState
  ): zio.aws.eventbridge.model.ReplayState = value match {
    case software.amazon.awssdk.services.eventbridge.model.ReplayState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.eventbridge.model.ReplayState.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.eventbridge.model.ReplayState.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.eventbridge.model.ReplayState.CANCELLING =>
      val r = CANCELLING
      r
    case software.amazon.awssdk.services.eventbridge.model.ReplayState.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.eventbridge.model.ReplayState.CANCELLED =>
      val r = CANCELLED
      r
    case software.amazon.awssdk.services.eventbridge.model.ReplayState.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.eventbridge.model.ReplayState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ReplayState =
      software.amazon.awssdk.services.eventbridge.model.ReplayState.UNKNOWN_TO_SDK_VERSION
  }
  case object STARTING extends zio.aws.eventbridge.model.ReplayState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ReplayState =
      software.amazon.awssdk.services.eventbridge.model.ReplayState.STARTING
  }
  case object RUNNING extends zio.aws.eventbridge.model.ReplayState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ReplayState =
      software.amazon.awssdk.services.eventbridge.model.ReplayState.RUNNING
  }
  case object CANCELLING extends zio.aws.eventbridge.model.ReplayState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ReplayState =
      software.amazon.awssdk.services.eventbridge.model.ReplayState.CANCELLING
  }
  case object COMPLETED extends zio.aws.eventbridge.model.ReplayState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ReplayState =
      software.amazon.awssdk.services.eventbridge.model.ReplayState.COMPLETED
  }
  case object CANCELLED extends zio.aws.eventbridge.model.ReplayState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ReplayState =
      software.amazon.awssdk.services.eventbridge.model.ReplayState.CANCELLED
  }
  case object FAILED extends zio.aws.eventbridge.model.ReplayState {
    override def unwrap
        : software.amazon.awssdk.services.eventbridge.model.ReplayState =
      software.amazon.awssdk.services.eventbridge.model.ReplayState.FAILED
  }
}
