package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class ReplayDestination(
    arn: Arn,
    filterArns: Optional[Iterable[Arn]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.ReplayDestination = {
    import ReplayDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.ReplayDestination
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .optionallyWith(
        filterArns.map(value =>
          value.map { item =>
            Arn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.filterArns)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.ReplayDestination.ReadOnly =
    zio.aws.eventbridge.model.ReplayDestination.wrap(buildAwsValue())
}
object ReplayDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.ReplayDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.ReplayDestination =
      zio.aws.eventbridge.model
        .ReplayDestination(arn, filterArns.map(value => value))
    def arn: Arn
    def filterArns: Optional[List[Arn]]
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getFilterArns: ZIO[Any, AwsError, List[Arn]] =
      AwsError.unwrapOptionField("filterArns", filterArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.ReplayDestination
  ) extends zio.aws.eventbridge.model.ReplayDestination.ReadOnly {
    override val arn: Arn = zio.aws.eventbridge.model.primitives.Arn(impl.arn())
    override val filterArns: Optional[List[Arn]] = zio.aws.core.internal
      .optionalFromNullable(impl.filterArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.eventbridge.model.primitives.Arn(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.ReplayDestination
  ): zio.aws.eventbridge.model.ReplayDestination.ReadOnly = new Wrapper(impl)
}
