package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{ErrorMessage, ErrorCode, TargetId}
import scala.jdk.CollectionConverters._
final case class RemoveTargetsResultEntry(
    targetId: Optional[TargetId] = Optional.Absent,
    errorCode: Optional[ErrorCode] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.RemoveTargetsResultEntry = {
    import RemoveTargetsResultEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.RemoveTargetsResultEntry
      .builder()
      .optionallyWith(
        targetId.map(value => TargetId.unwrap(value): java.lang.String)
      )(_.targetId)
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.RemoveTargetsResultEntry.ReadOnly =
    zio.aws.eventbridge.model.RemoveTargetsResultEntry.wrap(buildAwsValue())
}
object RemoveTargetsResultEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.RemoveTargetsResultEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.RemoveTargetsResultEntry =
      zio.aws.eventbridge.model.RemoveTargetsResultEntry(
        targetId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def targetId: Optional[TargetId]
    def errorCode: Optional[ErrorCode]
    def errorMessage: Optional[ErrorMessage]
    def getTargetId: ZIO[Any, AwsError, TargetId] =
      AwsError.unwrapOptionField("targetId", targetId)
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.RemoveTargetsResultEntry
  ) extends zio.aws.eventbridge.model.RemoveTargetsResultEntry.ReadOnly {
    override val targetId: Optional[TargetId] = zio.aws.core.internal
      .optionalFromNullable(impl.targetId())
      .map(value => zio.aws.eventbridge.model.primitives.TargetId(value))
    override val errorCode: Optional[ErrorCode] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => zio.aws.eventbridge.model.primitives.ErrorCode(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.eventbridge.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.RemoveTargetsResultEntry
  ): zio.aws.eventbridge.model.RemoveTargetsResultEntry.ReadOnly = new Wrapper(
    impl
  )
}
