package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{ErrorMessage, ErrorCode, TargetId}
import scala.jdk.CollectionConverters._
final case class PutTargetsResultEntry(
    targetId: Optional[TargetId] = Optional.Absent,
    errorCode: Optional[ErrorCode] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.PutTargetsResultEntry = {
    import PutTargetsResultEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.PutTargetsResultEntry
      .builder()
      .optionallyWith(
        targetId.map(value => TargetId.unwrap(value): java.lang.String)
      )(_.targetId)
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.PutTargetsResultEntry.ReadOnly =
    zio.aws.eventbridge.model.PutTargetsResultEntry.wrap(buildAwsValue())
}
object PutTargetsResultEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.PutTargetsResultEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.PutTargetsResultEntry =
      zio.aws.eventbridge.model.PutTargetsResultEntry(
        targetId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def targetId: Optional[TargetId]
    def errorCode: Optional[ErrorCode]
    def errorMessage: Optional[ErrorMessage]
    def getTargetId: ZIO[Any, AwsError, TargetId] =
      AwsError.unwrapOptionField("targetId", targetId)
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.PutTargetsResultEntry
  ) extends zio.aws.eventbridge.model.PutTargetsResultEntry.ReadOnly {
    override val targetId: Optional[TargetId] = zio.aws.core.internal
      .optionalFromNullable(impl.targetId())
      .map(value => zio.aws.eventbridge.model.primitives.TargetId(value))
    override val errorCode: Optional[ErrorCode] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => zio.aws.eventbridge.model.primitives.ErrorCode(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.eventbridge.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.PutTargetsResultEntry
  ): zio.aws.eventbridge.model.PutTargetsResultEntry.ReadOnly = new Wrapper(
    impl
  )
}
