package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class PutTargetsResponse(
    failedEntryCount: Optional[Integer] = Optional.Absent,
    failedEntries: Optional[
      Iterable[zio.aws.eventbridge.model.PutTargetsResultEntry]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.PutTargetsResponse = {
    import PutTargetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.PutTargetsResponse
      .builder()
      .optionallyWith(failedEntryCount.map(value => value: java.lang.Integer))(
        _.failedEntryCount
      )
      .optionallyWith(
        failedEntries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedEntries)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.PutTargetsResponse.ReadOnly =
    zio.aws.eventbridge.model.PutTargetsResponse.wrap(buildAwsValue())
}
object PutTargetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.PutTargetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.PutTargetsResponse =
      zio.aws.eventbridge.model.PutTargetsResponse(
        failedEntryCount.map(value => value),
        failedEntries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failedEntryCount: Optional[Integer]
    def failedEntries: Optional[
      List[zio.aws.eventbridge.model.PutTargetsResultEntry.ReadOnly]
    ]
    def getFailedEntryCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("failedEntryCount", failedEntryCount)
    def getFailedEntries: ZIO[Any, AwsError, List[
      zio.aws.eventbridge.model.PutTargetsResultEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("failedEntries", failedEntries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.PutTargetsResponse
  ) extends zio.aws.eventbridge.model.PutTargetsResponse.ReadOnly {
    override val failedEntryCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.failedEntryCount())
      .map(value => value: Integer)
    override val failedEntries: Optional[
      List[zio.aws.eventbridge.model.PutTargetsResultEntry.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.failedEntries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.eventbridge.model.PutTargetsResultEntry.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.PutTargetsResponse
  ): zio.aws.eventbridge.model.PutTargetsResponse.ReadOnly = new Wrapper(impl)
}
