package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{EventBusNameOrArn, RuleName}
import scala.jdk.CollectionConverters._
final case class PutTargetsRequest(
    rule: RuleName,
    eventBusName: Optional[EventBusNameOrArn] = Optional.Absent,
    targets: Iterable[zio.aws.eventbridge.model.Target]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.PutTargetsRequest = {
    import PutTargetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.PutTargetsRequest
      .builder()
      .rule(RuleName.unwrap(rule): java.lang.String)
      .optionallyWith(
        eventBusName.map(value =>
          EventBusNameOrArn.unwrap(value): java.lang.String
        )
      )(_.eventBusName)
      .targets(targets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.PutTargetsRequest.ReadOnly =
    zio.aws.eventbridge.model.PutTargetsRequest.wrap(buildAwsValue())
}
object PutTargetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.PutTargetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.PutTargetsRequest =
      zio.aws.eventbridge.model.PutTargetsRequest(
        rule,
        eventBusName.map(value => value),
        targets.map { item =>
          item.asEditable
        }
      )
    def rule: RuleName
    def eventBusName: Optional[EventBusNameOrArn]
    def targets: List[zio.aws.eventbridge.model.Target.ReadOnly]
    def getRule: ZIO[Any, Nothing, RuleName] = ZIO.succeed(rule)
    def getEventBusName: ZIO[Any, AwsError, EventBusNameOrArn] =
      AwsError.unwrapOptionField("eventBusName", eventBusName)
    def getTargets
        : ZIO[Any, Nothing, List[zio.aws.eventbridge.model.Target.ReadOnly]] =
      ZIO.succeed(targets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.PutTargetsRequest
  ) extends zio.aws.eventbridge.model.PutTargetsRequest.ReadOnly {
    override val rule: RuleName =
      zio.aws.eventbridge.model.primitives.RuleName(impl.rule())
    override val eventBusName: Optional[EventBusNameOrArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventBusName())
        .map(value =>
          zio.aws.eventbridge.model.primitives.EventBusNameOrArn(value)
        )
    override val targets: List[zio.aws.eventbridge.model.Target.ReadOnly] = impl
      .targets()
      .asScala
      .map { item =>
        zio.aws.eventbridge.model.Target.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.PutTargetsRequest
  ): zio.aws.eventbridge.model.PutTargetsRequest.ReadOnly = new Wrapper(impl)
}
