package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.{
  StatementId,
  Principal,
  Action,
  NonPartnerEventBusName
}
import scala.jdk.CollectionConverters._
final case class PutPermissionRequest(
    eventBusName: Optional[NonPartnerEventBusName] = Optional.Absent,
    action: Optional[Action] = Optional.Absent,
    principal: Optional[Principal] = Optional.Absent,
    statementId: Optional[StatementId] = Optional.Absent,
    condition: Optional[zio.aws.eventbridge.model.Condition] = Optional.Absent,
    policy: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.PutPermissionRequest = {
    import PutPermissionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.PutPermissionRequest
      .builder()
      .optionallyWith(
        eventBusName.map(value =>
          NonPartnerEventBusName.unwrap(value): java.lang.String
        )
      )(_.eventBusName)
      .optionallyWith(
        action.map(value => Action.unwrap(value): java.lang.String)
      )(_.action)
      .optionallyWith(
        principal.map(value => Principal.unwrap(value): java.lang.String)
      )(_.principal)
      .optionallyWith(
        statementId.map(value => StatementId.unwrap(value): java.lang.String)
      )(_.statementId)
      .optionallyWith(condition.map(value => value.buildAwsValue()))(
        _.condition
      )
      .optionallyWith(policy.map(value => value: java.lang.String))(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.PutPermissionRequest.ReadOnly =
    zio.aws.eventbridge.model.PutPermissionRequest.wrap(buildAwsValue())
}
object PutPermissionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.PutPermissionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.PutPermissionRequest =
      zio.aws.eventbridge.model.PutPermissionRequest(
        eventBusName.map(value => value),
        action.map(value => value),
        principal.map(value => value),
        statementId.map(value => value),
        condition.map(value => value.asEditable),
        policy.map(value => value)
      )
    def eventBusName: Optional[NonPartnerEventBusName]
    def action: Optional[Action]
    def principal: Optional[Principal]
    def statementId: Optional[StatementId]
    def condition: Optional[zio.aws.eventbridge.model.Condition.ReadOnly]
    def policy: Optional[String]
    def getEventBusName: ZIO[Any, AwsError, NonPartnerEventBusName] =
      AwsError.unwrapOptionField("eventBusName", eventBusName)
    def getAction: ZIO[Any, AwsError, Action] =
      AwsError.unwrapOptionField("action", action)
    def getPrincipal: ZIO[Any, AwsError, Principal] =
      AwsError.unwrapOptionField("principal", principal)
    def getStatementId: ZIO[Any, AwsError, StatementId] =
      AwsError.unwrapOptionField("statementId", statementId)
    def getCondition
        : ZIO[Any, AwsError, zio.aws.eventbridge.model.Condition.ReadOnly] =
      AwsError.unwrapOptionField("condition", condition)
    def getPolicy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.PutPermissionRequest
  ) extends zio.aws.eventbridge.model.PutPermissionRequest.ReadOnly {
    override val eventBusName: Optional[NonPartnerEventBusName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventBusName())
        .map(value =>
          zio.aws.eventbridge.model.primitives.NonPartnerEventBusName(value)
        )
    override val action: Optional[Action] = zio.aws.core.internal
      .optionalFromNullable(impl.action())
      .map(value => zio.aws.eventbridge.model.primitives.Action(value))
    override val principal: Optional[Principal] = zio.aws.core.internal
      .optionalFromNullable(impl.principal())
      .map(value => zio.aws.eventbridge.model.primitives.Principal(value))
    override val statementId: Optional[StatementId] = zio.aws.core.internal
      .optionalFromNullable(impl.statementId())
      .map(value => zio.aws.eventbridge.model.primitives.StatementId(value))
    override val condition
        : Optional[zio.aws.eventbridge.model.Condition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.condition())
        .map(value => zio.aws.eventbridge.model.Condition.wrap(value))
    override val policy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.PutPermissionRequest
  ): zio.aws.eventbridge.model.PutPermissionRequest.ReadOnly = new Wrapper(impl)
}
