package zio.aws.eventbridge.model
import zio.aws.eventbridge.model.primitives.{
  EventResource,
  EventSourceName,
  EventTime
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class PutPartnerEventsRequestEntry(
    time: Optional[EventTime] = Optional.Absent,
    source: Optional[EventSourceName] = Optional.Absent,
    resources: Optional[Iterable[EventResource]] = Optional.Absent,
    detailType: Optional[String] = Optional.Absent,
    detail: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.PutPartnerEventsRequestEntry = {
    import PutPartnerEventsRequestEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.PutPartnerEventsRequestEntry
      .builder()
      .optionallyWith(time.map(value => EventTime.unwrap(value): Instant))(
        _.time
      )
      .optionallyWith(
        source.map(value => EventSourceName.unwrap(value): java.lang.String)
      )(_.source)
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            EventResource.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resources)
      .optionallyWith(detailType.map(value => value: java.lang.String))(
        _.detailType
      )
      .optionallyWith(detail.map(value => value: java.lang.String))(_.detail)
      .build()
  }
  def asReadOnly
      : zio.aws.eventbridge.model.PutPartnerEventsRequestEntry.ReadOnly =
    zio.aws.eventbridge.model.PutPartnerEventsRequestEntry.wrap(buildAwsValue())
}
object PutPartnerEventsRequestEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.PutPartnerEventsRequestEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.PutPartnerEventsRequestEntry =
      zio.aws.eventbridge.model.PutPartnerEventsRequestEntry(
        time.map(value => value),
        source.map(value => value),
        resources.map(value => value),
        detailType.map(value => value),
        detail.map(value => value)
      )
    def time: Optional[EventTime]
    def source: Optional[EventSourceName]
    def resources: Optional[List[EventResource]]
    def detailType: Optional[String]
    def detail: Optional[String]
    def getTime: ZIO[Any, AwsError, EventTime] =
      AwsError.unwrapOptionField("time", time)
    def getSource: ZIO[Any, AwsError, EventSourceName] =
      AwsError.unwrapOptionField("source", source)
    def getResources: ZIO[Any, AwsError, List[EventResource]] =
      AwsError.unwrapOptionField("resources", resources)
    def getDetailType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("detailType", detailType)
    def getDetail: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("detail", detail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.PutPartnerEventsRequestEntry
  ) extends zio.aws.eventbridge.model.PutPartnerEventsRequestEntry.ReadOnly {
    override val time: Optional[EventTime] = zio.aws.core.internal
      .optionalFromNullable(impl.time())
      .map(value => zio.aws.eventbridge.model.primitives.EventTime(value))
    override val source: Optional[EventSourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.source())
      .map(value => zio.aws.eventbridge.model.primitives.EventSourceName(value))
    override val resources: Optional[List[EventResource]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.eventbridge.model.primitives.EventResource(item)
          }.toList
        )
    override val detailType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.detailType())
      .map(value => value: String)
    override val detail: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.detail())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.PutPartnerEventsRequestEntry
  ): zio.aws.eventbridge.model.PutPartnerEventsRequestEntry.ReadOnly =
    new Wrapper(impl)
}
