package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.eventbridge.model.primitives.EndpointId
import scala.jdk.CollectionConverters._
final case class PutEventsRequest(
    entries: Iterable[zio.aws.eventbridge.model.PutEventsRequestEntry],
    endpointId: Optional[EndpointId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.PutEventsRequest = {
    import PutEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.PutEventsRequest
      .builder()
      .entries(entries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        endpointId.map(value => EndpointId.unwrap(value): java.lang.String)
      )(_.endpointId)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.PutEventsRequest.ReadOnly =
    zio.aws.eventbridge.model.PutEventsRequest.wrap(buildAwsValue())
}
object PutEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.PutEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.PutEventsRequest =
      zio.aws.eventbridge.model.PutEventsRequest(
        entries.map { item =>
          item.asEditable
        },
        endpointId.map(value => value)
      )
    def entries: List[zio.aws.eventbridge.model.PutEventsRequestEntry.ReadOnly]
    def endpointId: Optional[EndpointId]
    def getEntries: ZIO[Any, Nothing, List[
      zio.aws.eventbridge.model.PutEventsRequestEntry.ReadOnly
    ]] = ZIO.succeed(entries)
    def getEndpointId: ZIO[Any, AwsError, EndpointId] =
      AwsError.unwrapOptionField("endpointId", endpointId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.PutEventsRequest
  ) extends zio.aws.eventbridge.model.PutEventsRequest.ReadOnly {
    override val entries
        : List[zio.aws.eventbridge.model.PutEventsRequestEntry.ReadOnly] = impl
      .entries()
      .asScala
      .map { item =>
        zio.aws.eventbridge.model.PutEventsRequestEntry.wrap(item)
      }
      .toList
    override val endpointId: Optional[EndpointId] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointId())
      .map(value => zio.aws.eventbridge.model.primitives.EndpointId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.PutEventsRequest
  ): zio.aws.eventbridge.model.PutEventsRequest.ReadOnly = new Wrapper(impl)
}
