package zio.aws.eventbridge.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.eventbridge.model.primitives.HealthCheck
import scala.jdk.CollectionConverters._
final case class Primary(healthCheck: HealthCheck) {
  def buildAwsValue()
      : software.amazon.awssdk.services.eventbridge.model.Primary = {
    import Primary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.eventbridge.model.Primary
      .builder()
      .healthCheck(HealthCheck.unwrap(healthCheck): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.eventbridge.model.Primary.ReadOnly =
    zio.aws.eventbridge.model.Primary.wrap(buildAwsValue())
}
object Primary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.eventbridge.model.Primary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.eventbridge.model.Primary =
      zio.aws.eventbridge.model.Primary(healthCheck)
    def healthCheck: HealthCheck
    def getHealthCheck: ZIO[Any, Nothing, HealthCheck] =
      ZIO.succeed(healthCheck)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.eventbridge.model.Primary
  ) extends zio.aws.eventbridge.model.Primary.ReadOnly {
    override val healthCheck: HealthCheck =
      zio.aws.eventbridge.model.primitives.HealthCheck(impl.healthCheck())
  }
  def wrap(
      impl: software.amazon.awssdk.services.eventbridge.model.Primary
  ): zio.aws.eventbridge.model.Primary.ReadOnly = new Wrapper(impl)
}
